/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaks.world;

import de.markusbordihn.adaptiveperformancetweaks.Manager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateViewDistancePacket;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class WorldViewManager
extends Manager {
    private static Map<String, Integer> viewDistancePerWorld = new ConcurrentHashMap<String, Integer>();
    private static int viewDistanceMin = (Integer)WorldViewManager.COMMON.viewDistanceMin.get();
    private static int viewDistanceMax = (Integer)WorldViewManager.COMMON.viewDistanceMax.get();
    private static int viewDistanceDefault = (Integer)WorldViewManager.COMMON.viewDistanceDefault.get();
    private static final Logger log = WorldViewManager.getLogger(WorldViewManager.class.getSimpleName());

    @SubscribeEvent
    public static void onServerAboutToStartEvent(FMLServerAboutToStartEvent event) {
        viewDistancePerWorld = new ConcurrentHashMap<String, Integer>();
        viewDistanceMin = (Integer)WorldViewManager.COMMON.viewDistanceMin.get();
        viewDistanceMax = (Integer)WorldViewManager.COMMON.viewDistanceMax.get();
        viewDistanceDefault = (Integer)WorldViewManager.COMMON.viewDistanceDefault.get();
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        log.info("ViewDistance will be optimized between {} and {} with {} as default", (Object)viewDistanceMin, (Object)viewDistanceMax, (Object)viewDistanceDefault);
    }

    public static void setViewDistance(ServerWorld serverWorld, Integer viewDistance) {
        if (viewDistance > viewDistanceMax) {
            viewDistance = viewDistanceMax;
        } else if (viewDistance < viewDistanceMin) {
            viewDistance = viewDistanceMin;
        }
        String serverWorldName = serverWorld.func_201672_e().func_234923_W_().func_240901_a_().toString();
        Integer currentViewDistance = viewDistancePerWorld.get(serverWorldName);
        if (currentViewDistance != null && currentViewDistance.equals(viewDistance)) {
            return;
        }
        log.info("Changing world view distance for {} from {} to {}", (Object)serverWorldName, (Object)currentViewDistance, (Object)viewDistance);
        List players = serverWorld.func_217369_A();
        if (!players.isEmpty()) {
            SUpdateViewDistancePacket viewDistancePacket = new SUpdateViewDistancePacket(viewDistance.intValue());
            for (ServerPlayerEntity player : players) {
                player.field_71135_a.func_147359_a((IPacket)viewDistancePacket);
            }
        }
        serverWorld.func_72863_F().func_217219_a(viewDistance.intValue());
        viewDistancePerWorld.put(serverWorldName, viewDistance);
    }

    public static void setDefaultViewDistance(ServerWorld serverWorld) {
        WorldViewManager.setViewDistance(serverWorld, viewDistanceDefault);
    }

    public static void setAvgViewDistance(ServerWorld serverWorld) {
        WorldViewManager.setViewDistance(serverWorld, (int)Math.round((double)(viewDistanceDefault + viewDistanceMin) / 2.0));
    }

    public static void increaseViewDistance(ServerWorld serverWorld) {
        Integer viewDistance = WorldViewManager.getViewDistance(serverWorld);
        WorldViewManager.setViewDistance(serverWorld, viewDistance + 1);
    }

    public static void decreaseViewDistance(ServerWorld serverWorld) {
        Integer viewDistance = WorldViewManager.getViewDistance(serverWorld);
        WorldViewManager.setViewDistance(serverWorld, viewDistance - 1);
    }

    public static int getViewDistance(ServerWorld serverWorld) {
        String serverWorldName = serverWorld.func_201672_e().func_234923_W_().func_240901_a_().toString();
        return WorldViewManager.getViewDistance(serverWorldName);
    }

    public static int getViewDistance(String serverWorldName) {
        return viewDistancePerWorld.getOrDefault(serverWorldName, viewDistanceDefault);
    }
}

