/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.device;

import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.HiveExtractorMapping;
import cofh.thermal.lib.util.managers.AbstractManager;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class HiveExtractorManager
extends AbstractManager {
    private static final int COMB_AMOUNT = 2;
    private static final int HONEY_AMOUNT = 250;
    private static final HiveExtractorManager INSTANCE = new HiveExtractorManager();
    protected IdentityHashMap<Block, Pair<ItemStack, FluidStack>> hiveMap = new IdentityHashMap();

    public static HiveExtractorManager instance() {
        return INSTANCE;
    }

    protected void clear() {
        this.hiveMap.clear();
    }

    public boolean specificHive(BlockState hive) {
        return this.hiveMap.containsKey(hive.func_177230_c());
    }

    public ItemStack getItem(BlockState hive) {
        return this.specificHive(hive) ? ItemHelper.cloneStack((ItemStack)((ItemStack)this.hiveMap.get(hive.func_177230_c()).getLeft())) : ItemHelper.cloneStack((Item)Items.field_226635_pU_, (int)2);
    }

    public FluidStack getFluid(BlockState hive) {
        return this.specificHive(hive) ? (FluidStack)this.hiveMap.get(hive.func_177230_c()).getRight() : new FluidStack((Fluid)CoreReferences.FLUID_HONEY, 250);
    }

    public void addMapping(HiveExtractorMapping mapping) {
        if (mapping.getHive() == Blocks.field_150350_a || mapping.getItem().func_190926_b() && mapping.getFluid().isEmpty()) {
            return;
        }
        this.hiveMap.put(mapping.getHive(), (Pair<ItemStack, FluidStack>)Pair.of((Object)mapping.getItem(), (Object)mapping.getFluid()));
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map mappings = recipeManager.func_215366_a(TCoreRecipeTypes.MAPPING_HIVE_EXTRACTOR);
        for (Map.Entry entry : mappings.entrySet()) {
            this.addMapping((HiveExtractorMapping)((Object)entry.getValue()));
        }
    }
}

