/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class LayeredIntersection4
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 7;
    private static final int Y_AXIS_LEN = 9;
    private static final int MAIN_AXIS_LEN = 7;
    private static final int LOCAL_X_END = 6;
    private static final int LOCAL_Y_END = 8;
    private static final int LOCAL_Z_END = 6;

    public LayeredIntersection4(TemplateManager structureManager, CompoundNBT compoundTag) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_4, compoundTag);
    }

    public LayeredIntersection4(int chainLength, Random random, MutableBoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.LAYERED_INTERSECTION_4, chainLength, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tag) {
        super.toNbt(tag);
    }

    public static MutableBoundingBox determineBoxPosition(List<StructurePiece> list, Random random, int x, int y, int z, Direction direction) {
        MutableBoundingBox blockBox = new MutableBoundingBox(x, y - 3, z, x, y - 3 + 9 - 1, z);
        switch (direction) {
            default: {
                blockBox.field_78893_d = x + 5;
                blockBox.field_78897_a = x - 1;
                blockBox.field_78896_c = z - 6;
                break;
            }
            case SOUTH: {
                blockBox.field_78893_d = x + 1;
                blockBox.field_78897_a = x - 5;
                blockBox.field_78892_f = z + 6;
                break;
            }
            case WEST: {
                blockBox.field_78897_a = x - 6;
                blockBox.field_78892_f = z;
                blockBox.field_78896_c = z - 5;
                break;
            }
            case EAST: {
                blockBox.field_78893_d = x + 6;
                blockBox.field_78892_f = z + 4;
                blockBox.field_78896_c = z - 1;
            }
        }
        StructurePiece intersectingPiece = StructurePiece.func_74883_a(list, (MutableBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
        Direction direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 5, Direction.EAST, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, Direction.WEST, this.chainLength);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, Direction.EAST, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 5, Direction.WEST, this.chainLength);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f, Direction.WEST, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - 5, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.chainLength);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, Direction.EAST, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 5, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, this.chainLength);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c - 1, Direction.NORTH, this.chainLength);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox box, ChunkPos pos, BlockPos blockPos) {
        if (this.func_74860_a((IBlockReader)world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 6, 6)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 6, 8, 6, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 6, 0, 6, this.getFloorSelector());
        this.fill(world, box, 2, 1, 2, 4, 1, 4, field_202556_l);
        this.fill(world, box, 2, 2, 1, 4, 2, 5, field_202556_l);
        this.fill(world, box, 2, 3, 0, 4, 6, 6, field_202556_l);
        this.fill(world, box, 0, 3, 2, 6, 6, 4, field_202556_l);
        this.replaceNonAir(world, box, 2, 0, 0, 4, 2, 6, this.getMainBlock());
        this.fill(world, box, 2, 2, 0, 2, 3, 1, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 2, 2, 0, 2, 3, 1, this.getBrickSelector());
        this.fill(world, box, 4, 2, 0, 4, 3, 1, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 4, 2, 0, 4, 3, 1, this.getBrickSelector());
        this.fill(world, box, 2, 2, 5, 2, 3, 6, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 2, 2, 5, 2, 3, 6, this.getBrickSelector());
        this.fill(world, box, 4, 2, 5, 4, 3, 6, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 4, 2, 5, 4, 3, 6, this.getBrickSelector());
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_SOUTH), 3, 3, 0, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_SOUTH), 3, 2, 1, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_SOUTH), 3, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)((BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a((Property)PoweredRailBlock.field_176568_b, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a((Property)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(true)), 3, 1, 3, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_NORTH), 3, 1, 4, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_NORTH), 3, 2, 5, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_NORTH), 3, 3, 6, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 2, 0, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 1, 1, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 0, 2, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 0, 3, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 0, 4, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 1, 5, box);
        this.func_175811_a(world, this.getMainBlock(), 3, 2, 6, box);
        this.fill(world, box, 0, 3, 2, 1, 3, 4, this.getMainBlock());
        this.fill(world, box, 2, 4, 2, 4, 4, 4, this.getMainBlock());
        this.fill(world, box, 5, 3, 2, 6, 3, 4, this.getMainBlock());
        this.chanceAddBlock(world, random, 0.5f, (BlockState)((BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a((Property)PoweredRailBlock.field_176568_b, (Comparable)RailShape.EAST_WEST)).func_206870_a((Property)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(true)), 0, 4, 3, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_EAST), 1, 4, 3, box);
        this.chanceFill(world, box, random, 0.5f, 2, 5, 3, 4, 5, 3, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.EAST_WEST));
        this.chanceAddBlock(world, random, 0.5f, (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.ASCENDING_WEST), 5, 4, 3, box);
        this.chanceAddBlock(world, random, 0.5f, (BlockState)((BlockState)Blocks.field_196552_aC.func_176223_P().func_206870_a((Property)PoweredRailBlock.field_176568_b, (Comparable)RailShape.EAST_WEST)).func_206870_a((Property)PoweredRailBlock.field_176569_M, (Comparable)Boolean.valueOf(true)), 6, 4, 3, box);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 6, 7, 6);
        this.addVines(world, box, random, this.settings.vineChance, 1, 0, 1, 5, 8, 5);
        return true;
    }
}

