/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.controls.GuiButton;
import team.creative.creativecore.common.gui.controls.GuiComboBox;
import team.creative.creativecore.common.gui.controls.GuiLabel;
import team.creative.creativecore.common.gui.controls.GuiLabelFixed;
import team.creative.creativecore.common.gui.controls.GuiScrollBox;
import team.creative.creativecore.common.gui.controls.layout.GuiLeftRightBox;
import team.creative.creativecore.common.gui.controls.layout.GuiVBox;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.GuiCreativeIngredientHandler;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextListBuilder;

public class FullItemDialogGuiLayer
extends GuiLayer {
    public static List<CreativeIngredient> latest = new ArrayList<CreativeIngredient>();
    public GuiInfoStackButton button;
    public GuiCreativeIngredientHandler handler;

    public FullItemDialogGuiLayer() {
        super("info", 250, 230);
        this.registerEventChanged(x -> {
            if (x.control.is("type")) {
                this.init();
            } else {
                this.handler.onChanged(this, (GuiControlChangedEvent)x);
            }
        });
    }

    @Override
    public void create() {
        if (this.button == null) {
            return;
        }
        CreativeIngredient info = this.button.get();
        this.handler = GuiCreativeIngredientHandler.getHandler(info);
        GuiComboBox box = (GuiComboBox)this.get("type");
        if (box != null) {
            this.handler = GuiCreativeIngredientHandler.get(box.getIndex());
        }
        this.clear();
        GuiVBox upperBox = new GuiVBox("upperBox", 0, 0, Align.STRETCH);
        ArrayList<String> lines = new ArrayList<String>(GuiCreativeIngredientHandler.getNames());
        box = new GuiComboBox("type", 0, 0, new TextListBuilder().add(lines));
        box.select(lines.indexOf(this.handler.getName()));
        upperBox.add(box);
        this.add(upperBox);
        this.handler.createControls(this, info);
        GuiScrollBox scroll = new GuiScrollBox("latest", 0, 150, 136, 65);
        int latestPerRow = 4;
        for (int i = 0; i < latest.size(); ++i) {
            int row = i / latestPerRow;
            int cell = i - row * latestPerRow;
            GuiLabel label = (GuiLabel)new GuiLabelFixed("" + i, cell * 18, row * 18, 18, 18){

                @Override
                public boolean mouseClicked(double x, double y, int button) {
                    FullItemDialogGuiLayer.this.button.set(latest.get(Integer.parseInt(this.name)));
                    FullItemDialogGuiLayer.this.closeTopLayer();
                    1.playSound(SoundEvents.field_187909_gi);
                    return true;
                }
            }.setTitle(new TextBuilder().stack(latest.get(i).getExample()).build()).setTooltip(GuiInfoStackButton.getLabelText(latest.get(i)));
            scroll.add(label);
        }
        this.add(scroll);
        GuiLeftRightBox actionBox = new GuiLeftRightBox("actionBox", 0, 130);
        actionBox.add(new GuiButton("cancel", 0, 130, x -> this.closeTopLayer()).setTitle((ITextComponent)new TranslationTextComponent("gui.cancel")));
        actionBox.addRight(new GuiButton("save", 100, 130, x -> {
            CreativeIngredient parsedInfo = this.handler.parseInfo(this);
            if (parsedInfo != null) {
                this.button.set(parsedInfo);
                if (!latest.contains(parsedInfo)) {
                    latest.add(0, parsedInfo.copy());
                }
                this.closeTopLayer();
            }
        }).setTitle((ITextComponent)new TranslationTextComponent("gui.save")));
        this.add(actionBox);
    }
}

