/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Rect {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;

    public Rect(double x, double y, double x2, double y2) {
        this.minX = x;
        this.minY = y;
        this.maxX = x2;
        this.maxY = y2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Rect getScreenRect() {
        Minecraft mc = Minecraft.func_71410_x();
        return new Rect(0.0, 0.0, mc.func_228018_at_().func_198107_o(), mc.func_228018_at_().func_198087_p());
    }

    public boolean intersects(Rect other) {
        return this.minX < other.maxX && this.maxX > other.minX && this.minY < other.maxY && this.maxY > other.minY;
    }

    public Rect intersection(Rect other) {
        if (this.intersects(other)) {
            double x = Math.max(this.minX, other.minX);
            double y = Math.max(this.minY, other.minY);
            double x2 = Math.min(this.maxX, other.maxX);
            double y2 = Math.min(this.maxY, other.maxY);
            return new Rect(x, y, x2, y2);
        }
        return null;
    }

    public void shrink(double shrink) {
        this.minX += shrink;
        this.minY += shrink;
        this.maxX -= shrink;
        this.maxY -= shrink;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getSize(Direction.Axis axis) {
        switch (axis) {
            case X: {
                return this.getWidth();
            }
            case Y: {
                return this.getHeight();
            }
        }
        return 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void scissor() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        double realMinX = this.minX * window.func_198100_s();
        double realMinY = (double)window.func_198091_l() - (this.minY + this.getHeight()) * window.func_198100_s();
        double realMaxX = this.getWidth() * window.func_198100_s();
        double realMaxY = this.getHeight() * window.func_198100_s();
        RenderSystem.enableScissor((int)((int)Math.floor(realMinX)), (int)((int)Math.floor(realMinY)), (int)((int)Math.ceil(realMaxX)), (int)((int)Math.ceil(realMaxY) + 1));
    }

    public Rect copy() {
        return new Rect(this.minX, this.minY, this.maxX, this.maxY);
    }

    public Rect child(double x, double y, double width, double height) {
        return new Rect(this.minX + x, this.minY + y, this.minX + x + width, this.minY + y + height);
    }

    public boolean inside(double x, double y) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY;
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.maxX + "," + this.maxY + "]";
    }
}

