/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.error;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ErrorsEntryListWidget
extends DynamicSmoothScrollingEntryListWidget<Entry> {
    private boolean inFocus;

    public ErrorsEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY, AbstractGui.field_230663_f_);
    }

    public boolean func_231049_c__(boolean boolean_1) {
        if (!this.inFocus && this.getItemCount() == 0) {
            return false;
        }
        boolean bl = this.inFocus = !this.inFocus;
        if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
            this.moveSelection(1);
        } else if (this.inFocus && this.getFocused() != null) {
            this.moveSelection(0);
        }
        return this.inFocus;
    }

    public void _clearItems() {
        this.clearItems();
    }

    private Entry _getEntry(int index) {
        return (Entry)((Object)this.func_231039_at__().get(index));
    }

    public void _addEntry(Entry entry) {
        this.addItem(entry);
    }

    public int getItemWidth() {
        return this.width - 80;
    }

    protected int getScrollbarPosition() {
        return this.width - 40;
    }

    public static abstract class Entry
    extends DynamicEntryListWidget.Entry<Entry> {
    }

    public static class LinkEntry
    extends Entry {
        private ITextComponent text;
        private List<IReorderingProcessor> textSplit;
        private String link;
        private boolean contains;

        public LinkEntry(ITextComponent text, String link, int width) {
            this.text = text;
            this.textSplit = Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)text, width - 6);
            this.link = link;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                Minecraft.func_71410_x().field_71462_r.func_238652_a_(matrices, (ITextComponent)new StringTextComponent("Click to open link."), mouseX, mouseY);
                int yy = y;
                for (IReorderingProcessor textSp : this.textSplit) {
                    IReorderingProcessor underlined = characterVisitor -> textSp.accept((charIndex, style, codePoint) -> characterVisitor.accept(charIndex, style.func_240721_b_(TextFormatting.UNDERLINE), codePoint));
                    Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, underlined, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (IReorderingProcessor textSp : this.textSplit) {
                    Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, textSp, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.contains && button == 0) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                try {
                    Util.func_110647_a().func_195642_a(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    public static class ImageEntry
    extends Entry {
        private DynamicTexture texture;
        private ResourceLocation id;
        private int width;
        private int height;

        public ImageEntry(int width, DynamicTexture texture, ResourceLocation id) {
            this.id = id;
            this.texture = texture;
            this.width = (width - 6) / 2;
            NativeImage image = texture.func_195414_e();
            this.height = (int)((double)this.width * ((double)image.func_195714_b() / (double)image.func_195702_a()));
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.id);
            NativeImage image = this.texture.func_195414_e();
            this.width = (entryWidth - 6) / 2;
            this.height = (int)((double)this.width * ((double)image.func_195714_b() / (double)image.func_195702_a()));
            ErrorsEntryListWidget.func_238467_a_((MatrixStack)matrices, (int)x, (int)y, (int)(x + this.width), (int)(y + this.height + 2), (int)-1);
            ErrorsEntryListWidget.func_238461_a_((Matrix4f)matrices.func_227866_c_().func_227870_a_(), (int)(x + 1), (int)(x + this.width - 1), (int)(y + 1), (int)(y + this.height + 1), (int)0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }

        public int getItemHeight() {
            return this.height + 2;
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }
    }

    public static class HorizontalRuleEntry
    extends Entry {
        private int width;

        public HorizontalRuleEntry(int width) {
            this.width = width;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.width != entryWidth) {
                this.width = entryWidth;
            }
            ErrorsEntryListWidget.func_238467_a_((MatrixStack)matrices, (int)(x + 2), (int)(y + 2), (int)(x + this.width - 6 - 2), (int)(y + 3), (int)-8947849);
        }

        public int getItemHeight() {
            return 5;
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }
    }

    public static class TextEntry
    extends Entry {
        private ITextComponent text;
        private int width;
        private List<IReorderingProcessor> textSplit;
        private int savedX;
        private int savedY;

        public TextEntry(ITextComponent text, int width) {
            this.text = text;
            this.width = width - 6;
            this.textSplit = text.getString().trim().isEmpty() ? Collections.singletonList(text.func_241878_f()) : Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)text, this.width);
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            HoverEvent hoverEvent;
            ITextComponent component;
            if (this.width != entryWidth - 6) {
                this.width = entryWidth - 6;
                this.textSplit = this.text.getString().trim().isEmpty() ? Collections.singletonList(this.text.func_241878_f()) : Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)this.text, this.width);
            }
            this.savedX = x;
            this.savedY = y;
            int yy = y;
            for (IReorderingProcessor textSp : this.textSplit) {
                Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, textSp, (float)(x + 5), (float)yy, -1);
                yy += 12;
            }
            Style style = this.getTextAt(mouseX, mouseY);
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (style != null && screen != null && style.func_150210_i() != null && (component = (ITextComponent)(hoverEvent = style.func_150210_i()).func_240662_a_(HoverEvent.Action.field_230550_a_)) != null) {
                screen.func_238654_b_(matrices, Minecraft.func_71410_x().field_71466_p.func_238425_b_((ITextProperties)component, Math.max(this.width / 2, 200)), x, y);
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean func_231049_c__(boolean boolean_1) {
            return false;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            Style style;
            if (button == 0 && (style = this.getTextAt(mouseX, mouseY)) != null && style.func_150235_h() != null) {
                ClickEvent clickEvent = style.func_150235_h();
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                try {
                    Util.func_110647_a().func_195642_a(new URI(clickEvent.func_150668_b()));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    return true;
                }
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }

        @Nullable
        private Style getTextAt(double x, double y) {
            int lineCount = this.textSplit.size();
            if (lineCount > 0) {
                int line;
                int textX = MathHelper.func_76128_c((double)(x - (double)this.savedX));
                int textY = MathHelper.func_76128_c((double)(y - (double)this.savedY));
                if (textX >= 0 && textY >= 0 && textX <= this.width && textY < 12 * lineCount + lineCount && (line = textY / 12) < this.textSplit.size()) {
                    IReorderingProcessor orderedText = this.textSplit.get(line);
                    return Minecraft.func_71410_x().field_71466_p.func_238420_b_().func_243239_a(orderedText, textX);
                }
            }
            return null;
        }
    }

    public static class ScaledEntry
    extends Entry
    implements INestedGuiEventHandler {
        public final Entry entry;
        public final float scale;
        public final Matrix4f transform;
        @Nullable
        private IGuiEventListener focused;
        private boolean isDragging;

        public ScaledEntry(Entry entry, float scale) {
            this.entry = entry;
            this.scale = scale;
            this.transform = Matrix4f.func_226593_a_((float)scale, (float)scale, (float)scale);
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        private Vector4f transformMouse(double mouseX, double mouseY) {
            Vector4f mouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
            mouse.func_229372_a_(this.transform);
            return mouse;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Vector4f mouse = this.transformMouse(mouseX, mouseY);
            matrices.func_227860_a_();
            matrices.func_227866_c_().func_227870_a_().func_226595_a_(this.transform);
            Vector4f pos = new Vector4f((float)x, (float)y, 0.0f, 1.0f);
            pos.func_229372_a_(Matrix4f.func_226593_a_((float)(1.0f / this.scale), (float)(1.0f / this.scale), (float)(1.0f / this.scale)));
            this.getEntry().render(matrices, index, Math.round(pos.func_195913_b()), Math.round(pos.func_195910_a()), Math.round((float)entryWidth / this.scale), Math.round((float)entryHeight / this.scale), (int)mouse.func_195910_a(), (int)mouse.func_195913_b(), isSelected, delta);
            matrices.func_227865_b_();
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.singletonList(this.getEntry());
        }

        public boolean func_231047_b_(double mouseX, double mouseY) {
            Vector4f mouse = this.transformMouse(mouseX, mouseY);
            return super.func_231047_b_((double)mouse.func_195910_a(), (double)mouse.func_195913_b());
        }

        public boolean func_231044_a_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231044_a_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), i);
        }

        public boolean func_231048_c_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231048_c_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), i);
        }

        public boolean func_231045_a_(double d, double e, int i, double f, double g) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231045_a_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), i, f, g);
        }

        public boolean func_231043_a_(double d, double e, double f) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.func_231043_a_((double)mouse.func_195910_a(), (double)mouse.func_195913_b(), f);
        }

        public final boolean func_231041_ay__() {
            return this.isDragging;
        }

        public final void func_231037_b__(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public IGuiEventListener func_241217_q_() {
            return this.focused;
        }

        public void func_231035_a_(@Nullable IGuiEventListener focused) {
            this.focused = focused;
        }
    }

    public static class IndentedEntry
    extends Entry
    implements INestedGuiEventHandler {
        public final Entry entry;
        public final int indent;
        @Nullable
        private IGuiEventListener focused;
        private boolean isDragging;

        public IndentedEntry(Entry entry, int indent) {
            this.entry = entry;
            this.indent = indent;
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.getEntry().render(matrices, index, y, x + this.indent, entryWidth - this.indent, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.singletonList(this.getEntry());
        }

        public final boolean func_231041_ay__() {
            return this.isDragging;
        }

        public final void func_231037_b__(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public IGuiEventListener func_241217_q_() {
            return this.focused;
        }

        public void func_231035_a_(@Nullable IGuiEventListener focused) {
            this.focused = focused;
        }
    }

    public static class EmptyEntry
    extends Entry {
        public final int height;

        public EmptyEntry(int height) {
            this.height = height;
        }

        public void render(MatrixStack poseStack, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        public int getItemHeight() {
            return this.height;
        }
    }
}

