/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.math.MathHelper;

public final class ArrowWidget
extends Arrow {
    private Rectangle bounds;
    private double animationDuration = -1.0;
    private final NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public ArrowWidget(Rectangle bounds) {
        this.bounds = new Rectangle(Objects.requireNonNull(bounds));
    }

    @Override
    public double getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    public void setAnimationDuration(double animationDurationMS) {
        this.animationDuration = animationDurationMS;
        if (this.animationDuration <= 0.0) {
            this.animationDuration = -1.0;
        }
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        this.renderBackground(matrices, false, 1.0f);
        this.renderBackground(matrices, true, ((Float)this.darkBackgroundAlpha.value()).floatValue());
    }

    public void renderBackground(MatrixStack matrices, boolean dark, float alpha) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(REIRuntime.getInstance().getDefaultDisplayTexture(dark));
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.getAnimationDuration() > 0.0) {
            int width = MathHelper.func_76143_f((double)((double)System.currentTimeMillis() / (this.animationDuration / 24.0) % 24.0));
            this.func_238474_b_(matrices, this.getX() + width, this.getY(), 106 + width, 91, 24 - width, 17);
            this.func_238474_b_(matrices, this.getX(), this.getY(), 82, 91, width, 17);
        } else {
            this.func_238474_b_(matrices, this.getX(), this.getY(), 106, 91, 24, 17);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return Collections.emptyList();
    }
}

