/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.common.entry.type.BuiltinEntryTypes;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.impl.client.entry.type.types.RenderingEntryDefinition;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeDeferred;
import me.shedaniel.rei.impl.common.entry.type.types.EmptyEntryDefinition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum DeferringEntryTypeProviderImpl implements Function<ResourceLocation, EntryType<?>>
{
    INSTANCE;

    ResourceLocation RENDERING_ID = new ResourceLocation("rendering");
    private Map<ResourceLocation, EntryType<?>> typeCache = new ConcurrentHashMap();
    private EntryType<Unit> empty;
    @OnlyIn(value=Dist.CLIENT)
    private EntryType<Renderer> render;

    @Override
    public EntryType<?> apply(ResourceLocation id) {
        if (id.equals((Object)BuiltinEntryTypes.EMPTY_ID)) {
            return this.typeCache.computeIfAbsent(id, this::emptyType);
        }
        if (id.equals((Object)this.RENDERING_ID) && Platform.getEnv() == Dist.CLIENT) {
            return this.typeCache.computeIfAbsent(id, this::renderingType);
        }
        return this.typeCache.computeIfAbsent(id, EntryTypeDeferred::new);
    }

    public EntryType<Unit> emptyType(final ResourceLocation id) {
        if (this.empty == null) {
            final int hashCode = id.hashCode();
            this.empty = new EntryType<Unit>(){

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public EntryDefinition<Unit> getDefinition() {
                    return EmptyEntryDefinition.EMPTY;
                }

                public int hashCode() {
                    return hashCode;
                }
            };
        }
        return this.empty;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EntryType<Renderer> renderingType(final ResourceLocation id) {
        if (this.render == null) {
            final int hashCode = id.hashCode();
            this.render = new EntryType<Renderer>(){

                @Override
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public EntryDefinition<Renderer> getDefinition() {
                    return RenderingEntryDefinition.RENDERING;
                }

                public int hashCode() {
                    return hashCode;
                }
            };
        }
        return this.render;
    }
}

