/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.architectury.hooks.forge.FluidStackHooksForge;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class JEIEntryDefinition<T>
implements EntryDefinition<T> {
    private final EntryType<T> type;
    private final IIngredientType<T> ingredientType;
    private final IIngredientHelper<T> ingredientHelper;
    private final Renderer<T> renderer;

    public JEIEntryDefinition(EntryType<T> type, IIngredientType<T> ingredientType, IIngredientHelper<T> ingredientHelper, IIngredientRenderer<T> ingredientRenderer) {
        this.type = type;
        this.ingredientType = ingredientType;
        this.ingredientHelper = ingredientHelper;
        this.renderer = new Renderer<T>(ingredientRenderer);
    }

    @Override
    public Class<T> getValueType() {
        return this.ingredientType.getIngredientClass();
    }

    @Override
    public EntryType<T> getType() {
        return this.type;
    }

    @Override
    public EntryRenderer<T> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<T> entry, T value) {
        String resourceId = this.ingredientHelper.getResourceId(value);
        if (resourceId == null) {
            return null;
        }
        return ResourceLocation.func_208304_a((String)resourceId);
    }

    @Override
    public boolean isEmpty(EntryStack<T> entry, T value) {
        return !this.ingredientHelper.isValidIngredient(value);
    }

    @Override
    public T copy(EntryStack<T> entry, T value) {
        return this.ingredientHelper.copyIngredient(value);
    }

    @Override
    public T normalize(EntryStack<T> entry, T value) {
        return this.ingredientHelper.normalizeIngredient(value);
    }

    @Override
    public long hash(EntryStack<T> entry, T value, ComparisonContext context) {
        return JEIEntryDefinition.hashCode(this.ingredientHelper.getUniqueId(value, JEIPluginDetector.wrapContext(context)));
    }

    private static long hashCode(String id) {
        long h = 0L;
        for (int i = 0; i < id.length(); ++i) {
            h = 31L * h + (long)id.charAt(i);
        }
        return h;
    }

    @Override
    public boolean equals(T o1, T o2, ComparisonContext context) {
        return Objects.equals(this.ingredientHelper.getUniqueId(o1, JEIPluginDetector.wrapContext(context)), this.ingredientHelper.getUniqueId(o2, JEIPluginDetector.wrapContext(context)));
    }

    @Override
    @Nullable
    public EntrySerializer<T> getSerializer() {
        return null;
    }

    @Override
    public ITextComponent asFormattedText(EntryStack<T> entry, T value) {
        return new ImmutableTextComponent(this.ingredientHelper.getDisplayName(value));
    }

    @Override
    public Collection<ResourceLocation> getTagsFor(ITagCollectionSupplier tagContainer, EntryStack<T> entry, T value) {
        return (Collection)EnvExecutor.getEnvSpecific(() -> () -> this._getTagsFor(value), () -> Collections::emptyList);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Collection<ResourceLocation> _getTagsFor(T value) {
        return this.ingredientHelper.getTags(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer<T>
    implements EntryRenderer<T> {
        private final IIngredientRenderer<T> ingredientRenderer;

        public Renderer(IIngredientRenderer<T> ingredientRenderer) {
            this.ingredientRenderer = ingredientRenderer;
        }

        @Override
        public void render(EntryStack<T> entry, MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            Object value = entry.getValue();
            if (value instanceof FluidStack) {
                value = FluidStackHooksForge.toForge((FluidStack)((FluidStack)value));
            }
            this.ingredientRenderer.render(matrices, bounds.getCenterX() - 8, bounds.getCenterY() - 8, value);
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<T> entry, Point mouse) {
            List<ITextComponent> components;
            Object value = entry.getValue();
            if (value instanceof FluidStack) {
                value = FluidStackHooksForge.toForge((FluidStack)((FluidStack)value));
            }
            if ((components = this.ingredientRenderer.getTooltip(value, (ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))) != null && !components.isEmpty()) {
                return Tooltip.create(mouse, components);
            }
            return null;
        }
    }
}

