/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.shedaniel.architectury.event.EventResult;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.category.visibility.CategoryVisibilityPredicate;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.unwrap.JEIUnwrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum JEIRecipeManager implements IRecipeManager
{
    INSTANCE;

    Set<CategoryIdentifier<?>> hiddenCategories = new HashSet();
    Map<CategoryIdentifier<?>, Set<Object>> hiddenRecipes = new HashMap();
    public DisplayPredicate displayPredicate = new DisplayPredicate();
    public CategoryPredicate categoryPredicate = new CategoryPredicate();

    @Override
    @Nullable
    public IRecipeCategory<?> getRecipeCategory(ResourceLocation recipeCategoryUid, boolean includeHidden) {
        try {
            DisplayCategory category = CategoryRegistry.getInstance().get(JEIPluginDetector.categoryId(recipeCategoryUid)).getCategory();
            if (CategoryRegistry.getInstance().isCategoryVisible(category)) {
                return new JEIUnwrappedCategory(category);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public <V> IFocus<V> createFocus(IFocus.Mode mode, V ingredient) {
        return new JEIFocus<V>(mode, ingredient);
    }

    @Override
    public <V> List<IRecipeCategory<?>> getRecipeCategories(@Nullable IFocus<V> focus, boolean includeHidden) {
        if (focus != null) {
            throw JEIPluginDetector.TODO();
        }
        return CollectionUtils.filterAndMap(CategoryRegistry.getInstance(), config -> includeHidden || CategoryRegistry.getInstance().isCategoryVisible(config.getCategory()), config -> new JEIUnwrappedCategory(config.getCategory()));
    }

    @Override
    public <V> List<IRecipeCategory<?>> getRecipeCategories(Collection<ResourceLocation> recipeCategoryUids, @Nullable IFocus<V> focus, boolean includeHidden) {
        if (focus != null) {
            throw JEIPluginDetector.TODO();
        }
        return CollectionUtils.map(recipeCategoryUids, id -> this.getRecipeCategory((ResourceLocation)id, includeHidden));
    }

    @Override
    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, @Nullable IFocus<V> focus, boolean includeHidden) {
        if (focus != null) {
            throw JEIPluginDetector.TODO();
        }
        return JEIPluginDetector.wrapRecipes(JEIPluginDetector.categoryId(recipeCategory.getUid()), !includeHidden);
    }

    @Override
    public List<Object> getRecipeCatalysts(IRecipeCategory<?> recipeCategory, boolean includeHidden) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (EntryIngredient stacks : CategoryRegistry.getInstance().get(JEIPluginDetector.categoryId(recipeCategory.getUid())).getWorkstations()) {
            objects.addAll(CollectionUtils.map(stacks, JEIPluginDetector::jeiValue));
        }
        return objects;
    }

    @Override
    @Nullable
    public <T> IRecipeLayoutDrawable createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocus<?> focus) {
        throw JEIPluginDetector.TODO();
    }

    @Override
    public <T> void hideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        Set recipes = this.hiddenRecipes.computeIfAbsent(JEIPluginDetector.categoryId(recipeCategoryUid), $ -> new HashSet());
        recipes.add(recipe);
    }

    @Override
    public <T> void unhideRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        CategoryIdentifier categoryIdentifier = JEIPluginDetector.categoryId(recipeCategoryUid);
        Set recipes = this.hiddenRecipes.computeIfAbsent(categoryIdentifier, $ -> new HashSet());
        recipes.remove(recipe);
        if (recipes.isEmpty()) {
            this.hiddenRecipes.remove(categoryIdentifier);
        }
    }

    @Override
    public void hideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.hiddenCategories.add(JEIPluginDetector.categoryId(recipeCategoryUid));
    }

    @Override
    public void unhideRecipeCategory(ResourceLocation recipeCategoryUid) {
        this.hiddenCategories.remove(JEIPluginDetector.categoryId(recipeCategoryUid));
    }

    @Override
    public <T> void addRecipe(T recipe, ResourceLocation recipeCategoryUid) {
        Collection<Display> displays = JEIPluginDetector.createDisplayFrom(recipe);
        for (Display display : displays) {
            if (!Objects.equals(display.getCategoryIdentifier().getIdentifier(), recipeCategoryUid)) continue;
            DisplayRegistry.getInstance().add(display, recipe);
        }
    }

    public class DisplayPredicate
    implements DisplayVisibilityPredicate {
        @Override
        public EventResult handleDisplay(DisplayCategory<?> category, Display display) {
            Set<Object> hidden = JEIRecipeManager.this.hiddenRecipes.get(category.getCategoryIdentifier());
            if (hidden != null && hidden.contains(JEIPluginDetector.jeiValue(display))) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        }
    }

    public class CategoryPredicate
    implements CategoryVisibilityPredicate {
        @Override
        public EventResult handleCategory(DisplayCategory<?> category) {
            if (JEIRecipeManager.this.hiddenCategories.contains(category.getCategoryIdentifier())) {
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        }
    }
}

