/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class DefaultInformationDisplay
implements Display {
    private EntryIngredient entryStacks;
    private List<ITextComponent> texts;
    private ITextComponent name;

    protected DefaultInformationDisplay(EntryIngredient entryStacks, ITextComponent name) {
        this.entryStacks = entryStacks;
        this.name = name;
        this.texts = Lists.newArrayList();
    }

    public static DefaultInformationDisplay createFromEntries(EntryIngredient entryStacks, ITextComponent name) {
        return new DefaultInformationDisplay(entryStacks, name);
    }

    public static DefaultInformationDisplay createFromEntry(EntryStack<?> entryStack, ITextComponent name) {
        return DefaultInformationDisplay.createFromEntries(EntryIngredient.of(entryStack), name);
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.entryStacks);
    }

    public DefaultInformationDisplay line(ITextComponent line) {
        this.texts.add(line);
        return this;
    }

    public DefaultInformationDisplay lines(ITextComponent ... lines) {
        this.texts.addAll(Arrays.asList(lines));
        return this;
    }

    public DefaultInformationDisplay lines(Collection<ITextComponent> lines) {
        this.texts.addAll(lines);
        return this;
    }

    public EntryIngredient getEntryStacks() {
        return this.entryStacks;
    }

    public ITextComponent getName() {
        return this.name;
    }

    public List<ITextComponent> getTexts() {
        return this.texts;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }

    public static DisplaySerializer<DefaultInformationDisplay> serializer() {
        return new DisplaySerializer<DefaultInformationDisplay>(){

            @Override
            public CompoundNBT save(CompoundNBT tag, DefaultInformationDisplay display) {
                tag.func_218657_a("stacks", (INBT)display.getEntryStacks().save());
                tag.func_74778_a("name", ITextComponent.Serializer.func_150696_a((ITextComponent)display.getName()));
                ListNBT descriptions = new ListNBT();
                for (ITextComponent text : display.getTexts()) {
                    descriptions.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)text)));
                }
                tag.func_218657_a("descriptions", (INBT)descriptions);
                return tag;
            }

            @Override
            public DefaultInformationDisplay read(CompoundNBT tag) {
                EntryIngredient stacks = EntryIngredient.read(tag.func_150295_c("stacks", 10));
                IFormattableTextComponent name = ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("name"));
                ArrayList<ITextComponent> descriptions = new ArrayList<ITextComponent>();
                for (INBT descriptionTag : tag.func_150295_c("descriptions", 8)) {
                    descriptions.add((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)descriptionTag.func_150285_a_()));
                }
                return new DefaultInformationDisplay(stacks, (ITextComponent)name).lines(descriptions);
            }
        };
    }
}

