/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.UnsignedValueConstant;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public final class UIntValue
extends UnsignedValueConstant<Integer> {
    public UIntValue(int intValue) {
        super(intValue);
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(module, "module");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(module, StandardNames.FqNames.uInt);
        if (classDescriptor == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unsigned type UInt not found");
            Intrinsics.checkNotNullExpressionValue(simpleType2, "createErrorType(\"Unsigned type UInt not found\")");
            kotlinType = simpleType2;
        } else {
            SimpleType simpleType3 = classDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "module.findClassAcrossMo\u2026ned type UInt not found\")");
            kotlinType = simpleType3;
        }
        return kotlinType;
    }

    @Override
    @NotNull
    public String toString() {
        return ((Number)this.getValue()).intValue() + ".toUInt()";
    }
}

