/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetBurnTime;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetFood;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetImmuneToFire;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetMaxDamage;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetMaxStackSize;
import com.blamejared.crafttweaker.impl.actions.items.ActionSetRarity;
import com.blamejared.crafttweaker.impl.data.MapData;
import com.blamejared.crafttweaker.impl.food.MCFood;
import com.blamejared.crafttweaker.impl.item.MCWeightedItemStack;
import com.blamejared.crafttweaker.impl.util.text.MCTextComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.ZenWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.IItemStack")
@Document(value="vanilla/api/items/IItemStack")
@ZenWrapper(wrappedClass="net.minecraft.item.ItemStack", displayStringFormat="%s.getCommandString()", creationMethodFormat="new MCItemStack(%s)", implementingClass="com.blamejared.crafttweaker.impl.item.MCItemStack")
public interface IItemStack
extends IIngredient,
IIngredientWithAmount {
    @ZenCodeType.Field
    public static final String CRAFTTWEAKER_DATA_KEY = "CraftTweakerData";

    @ZenCodeType.Method
    public IItemStack copy();

    @ZenCodeType.Getter(value="registryName")
    default public ResourceLocation getRegistryName() {
        return this.getInternal().func_77973_b().getRegistryName();
    }

    @ZenCodeType.Getter(value="owner")
    default public String getOwner() {
        ResourceLocation registryName = this.getInternal().func_77973_b().getRegistryName();
        return registryName == null ? "error" : registryName.func_110624_b();
    }

    @ZenCodeType.Getter(value="empty")
    default public boolean isEmpty() {
        return this.getInternal().func_190926_b();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="maxStackSize")
    default public int getMaxStackSize() {
        return this.getInternal().func_77973_b().getItemStackLimit(this.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="maxStackSize")
    default public void setMaxStackSize(int newMaxStackSize) {
        CraftTweakerAPI.apply(new ActionSetMaxStackSize(this, newMaxStackSize, this.getInternal().func_77973_b().field_77777_bU));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="rarity")
    default public Rarity getRarity() {
        return this.getInternal().func_77953_t();
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="rarity")
    default public void setRarity(Rarity newRarity) {
        CraftTweakerAPI.apply(new ActionSetRarity(this, newRarity, this.getInternal().func_77953_t()));
    }

    @ZenCodeType.Getter(value="displayName")
    default public String getDisplayName() {
        return this.getInternal().func_200301_q().getString();
    }

    @ZenCodeType.Method
    public IItemStack setDisplayName(String var1);

    @ZenCodeType.Method
    default public IItemStack withDisplayName(MCTextComponent text) {
        return this.setDisplayName(text.asString());
    }

    @ZenCodeType.Method
    default public void clearCustomName() {
        this.getInternal().func_135074_t();
    }

    @ZenCodeType.Getter(value="hasDisplayName")
    default public boolean hasDisplayName() {
        return this.getInternal().func_82837_s();
    }

    @ZenCodeType.Getter(value="hasEffect")
    default public boolean hasEffect() {
        return this.getInternal().func_77962_s();
    }

    @ZenCodeType.Getter(value="isEnchantable")
    default public boolean isEnchantable() {
        return this.getInternal().func_77956_u();
    }

    @ZenCodeType.Getter(value="isEnchanted")
    default public boolean isEnchanted() {
        return this.getInternal().func_77948_v();
    }

    @ZenCodeType.Getter(value="getRepairCost")
    default public int getRepairCost() {
        return this.getInternal().func_82838_A();
    }

    @Override
    @ZenCodeType.Getter(value="amount")
    default public int getAmount() {
        return this.getInternal().func_190916_E();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public IItemStack setAmount(int var1);

    @ZenCodeType.Method
    public IItemStack grow(@ZenCodeType.OptionalInt(value=1) int var1);

    @ZenCodeType.Method
    public IItemStack shrink(@ZenCodeType.OptionalInt(value=1) int var1);

    @ZenCodeType.Getter(value="stackable")
    default public boolean isStackable() {
        return this.getInternal().func_77985_e();
    }

    @ZenCodeType.Method
    public IItemStack withDamage(int var1);

    @ZenCodeType.Method
    public IItemStack withAttributeModifier(Attribute var1, String var2, String var3, double var4, AttributeModifier.Operation var6, EquipmentSlotType[] var7, @ZenCodeType.OptionalBoolean boolean var8);

    @ZenCodeType.Method
    public IItemStack withAttributeModifier(Attribute var1, String var2, double var3, AttributeModifier.Operation var5, EquipmentSlotType[] var6, @ZenCodeType.OptionalBoolean boolean var7);

    @ZenCodeType.Method
    default public Map<Attribute, List<AttributeModifier>> getAttributes(EquipmentSlotType slotType) {
        return this.getInternal().func_111283_C(slotType).asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, attributeAttributeModifierEntry -> new ArrayList((Collection)attributeAttributeModifierEntry.getValue())));
    }

    @ZenCodeType.Getter(value="damageable")
    default public boolean isDamageable() {
        return this.getInternal().func_77984_f();
    }

    @ZenCodeType.Getter(value="damaged")
    default public boolean isDamaged() {
        return this.getInternal().func_77951_h();
    }

    @ZenCodeType.Getter(value="maxDamage")
    default public int getMaxDamage() {
        return this.getInternal().func_77958_k();
    }

    @ZenCodeType.Setter(value="maxDamage")
    default public void setMaxDamage(int maxDamage) {
        CraftTweakerAPI.apply(new ActionSetMaxDamage(this, maxDamage, this.getInternal().func_77958_k()));
    }

    @ZenCodeType.Getter(value="translationKey")
    default public String getTranslationKey() {
        return this.getInternal().func_77977_a();
    }

    @ZenCodeType.Method
    public IItemStack withTag(IData var1);

    @ZenCodeType.Method
    public IItemStack withoutTag();

    @ZenCodeType.Getter(value="hasTag")
    default public boolean hasTag() {
        return this.getInternal().func_77942_o();
    }

    @ZenCodeType.Getter(value="tag")
    default public IData getTag() {
        return NBTConverter.convert((INBT)this.getInternal().func_77978_p());
    }

    @ZenCodeType.Getter(value="getOrCreate")
    default public IData getOrCreateTag() {
        if (this.getInternal().func_77978_p() == null) {
            this.getInternal().func_77982_d(new CompoundNBT());
        }
        return NBTConverter.convert((INBT)this.getInternal().func_77978_p());
    }

    @Override
    default public boolean matches(IItemStack stack, boolean ignoreDamage) {
        ItemStack stack1 = this.getInternal();
        ItemStack stack2 = stack.getInternal();
        if (stack1.func_190926_b() != stack2.func_190926_b()) {
            return false;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_190916_E() > stack2.func_190916_E()) {
            return false;
        }
        if (!ignoreDamage && stack1.func_77952_i() != stack2.func_77952_i()) {
            return false;
        }
        CompoundNBT stack1Tag = stack1.func_77978_p();
        CompoundNBT stack2Tag = stack2.func_77978_p();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        MapData stack2Data = (MapData)NBTConverter.convert((INBT)stack2Tag);
        MapData stack1Data = (MapData)NBTConverter.convert((INBT)stack1Tag);
        if (stack1Data == null) {
            return true;
        }
        if (ignoreDamage) {
            stack1Data = (MapData)stack1Data.copyInternal();
            stack1Data.remove("Damage");
            if (stack2Data != null) {
                stack2Data = (MapData)stack2Data.copyInternal();
                stack2Data.remove("Damage");
            }
        }
        return stack2Data != null && stack2Data.contains(stack1Data);
    }

    @ZenCodeType.Getter(value="useDuration")
    default public int getUseDuration() {
        return this.getInternal().func_77988_m();
    }

    @ZenCodeType.Getter(value="isCrossbow")
    default public boolean isCrossbowStack() {
        return this.getInternal().func_222122_m();
    }

    @ZenCodeType.Getter(value="food")
    default public @ZenCodeType.Nullable MCFood getFood() {
        Food food = this.getInternal().func_77973_b().func_219967_s();
        return food == null ? null : new MCFood(food);
    }

    @ZenCodeType.Setter(value="food")
    default public void setFood(MCFood food) {
        CraftTweakerAPI.apply(new ActionSetFood(this, food, this.getInternal().func_77973_b().func_219967_s()));
    }

    @ZenCodeType.Method
    default public boolean isFood() {
        return this.getInternal().func_222117_E();
    }

    @ZenCodeType.Getter(value="burnTime")
    default public int getBurnTime() {
        return ForgeHooks.getBurnTime((ItemStack)this.getInternal());
    }

    @Override
    @ZenCodeType.Setter(value="burnTime")
    default public void setBurnTime(int time) {
        CraftTweakerAPI.apply(new ActionSetBurnTime(this, time));
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="immuneToFire")
    default public void setImmuneToFire(boolean immuneToFire) {
        CraftTweakerAPI.apply(new ActionSetImmuneToFire(this, immuneToFire, this.getInternal().func_77973_b().field_234684_d_));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="immuneToFire")
    default public boolean isImmuneToFire() {
        return this.getInternal().func_77973_b().func_234687_u_();
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MOD)
    default public MCWeightedItemStack percent(int percentage) {
        return this.weight((double)percentage / 100.0);
    }

    @ZenCodeType.Method
    default public MCWeightedItemStack weight(double weight) {
        return new MCWeightedItemStack(this, weight);
    }

    @ZenCodeType.Caster(implicit=true)
    default public MCWeightedItemStack asWeightedItemStack() {
        return this.weight(1.0);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="definition")
    @ZenCodeType.Caster(implicit=true)
    default public Item getDefinition() {
        return this.getInternal().func_77973_b();
    }

    @ZenCodeType.Method
    public IItemStack mutable();

    @ZenCodeType.Method
    public IItemStack asImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Getter(value="damage")
    public int getDamage();

    @ZenCodeType.Getter(value="toolTypes")
    default public ToolType[] getToolTypes() {
        return this.getInternal().getToolTypes().toArray(new ToolType[0]);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    default public Map<Enchantment, Integer> getEnchantments() {
        return EnchantmentHelper.func_82781_a((ItemStack)this.getInternal());
    }

    @ZenCodeType.Method
    @ZenCodeType.Setter(value="enchantments")
    public IItemStack setEnchantments(Map<Enchantment, Integer> var1);

    @ZenCodeType.Method
    default public int getEnchantmentLevel(Enchantment enchantment) {
        return this.getEnchantments().getOrDefault(enchantment, 0);
    }

    @ZenCodeType.Method
    public IItemStack withEnchantment(Enchantment var1, @ZenCodeType.OptionalInt(value=1) int var2);

    @ZenCodeType.Method
    public IItemStack removeEnchantment(Enchantment var1);

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public ItemStack getInternal();

    @ZenCodeType.Method
    public ItemStack getImmutableInternal();

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    default public IIngredientWithAmount asIIngredientWithAmount() {
        return this;
    }

    @Override
    default public IItemStack getIngredient() {
        return this;
    }
}

