/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.villagers;

import com.blamejared.crafttweaker.api.util.MethodHandleHelper;
import java.lang.invoke.MethodHandle;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BasicTrade;

public class BasicTradeExposer {
    private static final MethodHandle PRICE_GETTER = MethodHandleHelper.linkGetter(BasicTrade.class, "price");
    private static final MethodHandle PRICE2_GETTER = MethodHandleHelper.linkGetter(BasicTrade.class, "price2");
    private static final MethodHandle FOR_SALE_GETTER = MethodHandleHelper.linkGetter(BasicTrade.class, "forSale");
    private static final MethodHandle MAX_TRADES_GETTER = MethodHandleHelper.linkGetter(BasicTrade.class, "maxTrades");
    private static final MethodHandle XP_GETTER = MethodHandleHelper.linkGetter(BasicTrade.class, "xp");
    private static final MethodHandle PRICE_MULT_GETTER = MethodHandleHelper.linkGetter(BasicTrade.class, "priceMult");

    public static ItemStack getPrice(VillagerTrades.ITrade trade) {
        return BasicTradeExposer.invoke(trade, it -> PRICE_GETTER.invokeExact(it));
    }

    public static ItemStack getPrice2(VillagerTrades.ITrade trade) {
        return BasicTradeExposer.invoke(trade, it -> PRICE2_GETTER.invokeExact(it));
    }

    public static ItemStack getForSale(VillagerTrades.ITrade trade) {
        return BasicTradeExposer.invoke(trade, it -> FOR_SALE_GETTER.invokeExact(it));
    }

    public static int getMaxTrades(VillagerTrades.ITrade trade) {
        return BasicTradeExposer.invoke(trade, it -> MAX_TRADES_GETTER.invokeExact(it));
    }

    public static int getXP(VillagerTrades.ITrade trade) {
        return BasicTradeExposer.invoke(trade, it -> XP_GETTER.invokeExact(it));
    }

    public static float getPriceMult(VillagerTrades.ITrade trade) {
        return BasicTradeExposer.invoke(trade, it -> Float.valueOf(PRICE_MULT_GETTER.invokeExact(it))).floatValue();
    }

    private static <T> T invoke(VillagerTrades.ITrade trade, TradeFunction<T> function) {
        if (trade instanceof BasicTrade) {
            return (T)MethodHandleHelper.invoke(() -> function.apply((BasicTrade)trade));
        }
        throw new IllegalArgumentException(trade.getClass() + " is not of type BasicTrade!");
    }

    private static interface TradeFunction<T> {
        public T apply(BasicTrade var1) throws Throwable;
    }
}

