/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.loaders;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.zencode.brackets.CTRegisterBEPEvent;
import com.blamejared.crafttweaker.api.zencode.brackets.IgnorePrefixCasingBracketParser;
import com.blamejared.crafttweaker.api.zencode.brackets.ValidatedEscapableBracketParser;
import com.blamejared.crafttweaker.api.zencode.impl.loaders.LoaderActions;
import com.blamejared.crafttweaker.api.zencode.impl.native_types.CrTJavaNativeConverterBuilder;
import com.blamejared.crafttweaker.impl.logger.GroupLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.openzen.zencode.java.ScriptingEngine;
import org.openzen.zencode.java.module.JavaNativeModule;
import org.openzen.zencode.java.module.converters.JavaNativeConverterBuilder;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.ScriptBlock;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.formatter.FileFormatter;
import org.openzen.zenscript.formatter.ScriptFormattingSettings;
import org.openzen.zenscript.lexer.ParseException;

public class ScriptRun {
    private final ScriptLoadingOptions scriptLoadingOptions;
    private final SourceFile[] sourceFiles;
    private final ScriptingEngine scriptingEngine;
    private IgnorePrefixCasingBracketParser bep;

    public ScriptRun(ScriptLoadingOptions scriptLoadingOptions, SourceFile[] sourceFiles) {
        this.scriptLoadingOptions = scriptLoadingOptions;
        this.sourceFiles = sourceFiles;
        this.scriptingEngine = new ScriptingEngine(CraftTweakerAPI.logger);
        this.scriptingEngine.debug = CraftTweakerAPI.DEBUG_MODE;
    }

    public LoaderActions getLoaderActions() {
        return LoaderActions.getActionForLoader(this.scriptLoadingOptions.getLoaderName());
    }

    public boolean isFirstRun() {
        return this.getLoaderActions().isFirstRun();
    }

    public ScriptingEngine getEngine() {
        return this.scriptingEngine;
    }

    public void reload() {
        if (this.scriptLoadingOptions.isExecute()) {
            this.getLoaderActions().reload();
        }
        if (CraftTweakerAPI.logger instanceof GroupLogger) {
            ((GroupLogger)CraftTweakerAPI.logger).getPreviousMessages().clear();
        } else {
            String message = "Internal Error: Expected Logger to be a GroupLogger, but found '%s'. This is most likely an issue with a CrT addon!";
            String loggerClassName = CraftTweakerAPI.logger.getClass().getCanonicalName();
            CraftTweakerAPI.logError("Internal Error: Expected Logger to be a GroupLogger, but found '%s'. This is most likely an issue with a CrT addon!", loggerClassName);
        }
    }

    public void run() throws Exception {
        if (!this.scriptLoadingOptions.isExecute()) {
            CraftTweakerAPI.logInfo("This is only a syntax check. Script changes will not be applied.", new Object[0]);
        }
        if (this.isFirstRun()) {
            CraftTweakerAPI.logDebug("This is a first run. All IActions will be applied.", new Object[0]);
        }
        this.initializeBep();
        this.registerModules();
        this.readAndExecuteScripts();
    }

    private void initializeBep() {
        this.bep = new IgnorePrefixCasingBracketParser();
        MinecraftForge.EVENT_BUS.post((Event)new CTRegisterBEPEvent(this.bep));
    }

    private void readAndExecuteScripts() throws ParseException {
        SemanticModule scripts = this.scriptingEngine.createScriptedModule("scripts", this.sourceFiles, this.bep, FunctionParameter.NONE, new String[0]);
        if (!scripts.isValid()) {
            CraftTweakerAPI.logger.error("Scripts are invalid!");
            CraftTweaker.LOG.info("Scripts are invalid!");
            return;
        }
        if (this.scriptLoadingOptions.isFormat()) {
            this.writeFormattedFiles(scripts);
        }
        if (this.scriptLoadingOptions.isExecute()) {
            LoaderActions loaderActions = this.getLoaderActions();
            CraftTweakerAPI.logDebug("This is loader '%s' run #%s", this.scriptLoadingOptions.getLoaderName(), loaderActions.getRunCount() + 1);
            this.scriptingEngine.registerCompiled(scripts);
            this.scriptingEngine.run(Collections.emptyMap(), CraftTweaker.class.getClassLoader());
            loaderActions.incrementRunCount();
        } else if (CraftTweakerAPI.DEBUG_MODE) {
            this.scriptingEngine.createRunUnit().dump(new File("classes"));
        }
    }

    private void registerModules() throws CompileException {
        LinkedList<JavaNativeModule> modules = new LinkedList<JavaNativeModule>();
        CrTJavaNativeConverterBuilder nativeConverterBuilder = new CrTJavaNativeConverterBuilder();
        JavaNativeModule crafttweakerModule = this.createModule(this.bep, "crafttweaker", "crafttweaker", nativeConverterBuilder, new JavaNativeModule[0]);
        this.scriptingEngine.registerNativeProvided(crafttweakerModule);
        modules.add(crafttweakerModule);
        HashSet<String> rootPackages = new HashSet<String>(CraftTweakerRegistry.getRootPackages());
        rootPackages.remove("crafttweaker");
        for (String rootPackage : rootPackages) {
            JavaNativeModule module = this.createModule(this.bep, rootPackage, rootPackage, nativeConverterBuilder, crafttweakerModule);
            this.scriptingEngine.registerNativeProvided(module);
            modules.add(module);
        }
        JavaNativeModule expModule = this.createModule(this.bep, "expansions", "", nativeConverterBuilder, modules.toArray(new JavaNativeModule[0]));
        for (List<Class<?>> expansionList : CraftTweakerRegistry.getExpansions().values()) {
            for (Class<?> expansionClass : expansionList) {
                expModule.addClass(expansionClass);
            }
        }
        this.scriptingEngine.registerNativeProvided(expModule);
        nativeConverterBuilder.headerConverter.reinitializeAllLazyValues();
    }

    private JavaNativeModule createModule(IgnorePrefixCasingBracketParser bep, String moduleName, String basePackage, JavaNativeConverterBuilder nativeConverterBuilder, JavaNativeModule ... dependencies) {
        JavaNativeModule module = this.scriptingEngine.createNativeModule(moduleName, basePackage, dependencies, nativeConverterBuilder);
        for (ValidatedEscapableBracketParser validatedEscapableBracketParser : CraftTweakerRegistry.getBracketResolvers(moduleName, this.scriptingEngine, module)) {
            bep.register(validatedEscapableBracketParser.getName(), validatedEscapableBracketParser);
        }
        module.registerBEP(bep);
        for (Class clazz : CraftTweakerRegistry.getGlobalsInPackage(moduleName)) {
            module.addGlobals(clazz);
        }
        for (Class clazz : CraftTweakerRegistry.getClassesInPackage(moduleName)) {
            module.addClass(clazz);
        }
        return module;
    }

    private void writeFormattedFiles(SemanticModule scripts) {
        List<HighLevelDefinition> all = scripts.definitions.getAll();
        ScriptFormattingSettings.Builder builder = new ScriptFormattingSettings.Builder();
        FileFormatter formatter = new FileFormatter(builder.build());
        List<ScriptBlock> blocks = scripts.scripts;
        for (ScriptBlock block : blocks) {
            String format = formatter.format(scripts.rootPackage, block, all);
            File parent = new File("scriptsFormatted");
            File file = new File(parent, block.file.getFilename());
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                CraftTweakerAPI.logError("Could not find or create folder %s, aborting formatting task!", file.getParent());
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                Throwable throwable = null;
                try {
                    writer.write(format);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (IOException e) {
                CraftTweakerAPI.logThrowing("Could not write formatted files", e, new Object[0]);
            }
        }
    }
}

