/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.zencode.impl.registry.wrapper;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.openzen.zencode.java.ZenCodeType;

public class WrapperRegistryEntry {
    private final Class<?> wrappedClass;
    private final Class<?> wrapperClass;

    public WrapperRegistryEntry(Class<?> wrappedClass, Class<?> wrapperClass) {
        this.wrappedClass = wrappedClass;
        this.wrapperClass = wrapperClass;
    }

    public Class<?> getWrappedClass() {
        return this.wrappedClass;
    }

    public Class<?> getWrapperClass() {
        return this.wrapperClass;
    }

    public String getWrapperClassZCName() {
        return this.getWrapperClass().getAnnotation(ZenCodeType.Name.class).value();
    }

    @Nullable
    public MethodHandle getWrapperHandle() {
        try {
            Constructor<?> constructor = this.getWrapperClass().getConstructor(this.getWrappedClass());
            return MethodHandles.lookup().unreflectConstructor(constructor);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            CraftTweakerAPI.logWarning("Could not find WrapperHandle for " + this.getWrapperClass(), new Object[0]);
            return null;
        }
    }

    @Nullable
    public MethodHandle getUnwrapperHandle() {
        try {
            Method getInternalMethod = this.getWrapperClass().getMethod("getInternal", new Class[0]);
            return MethodHandles.lookup().unreflect(getInternalMethod);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            CraftTweakerAPI.logWarning("Could not find UnwrapperHandle for " + this.getWrapperClass(), new Object[0]);
            return null;
        }
    }
}

