/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class ActionAddRecipe
extends ActionRecipeBase {
    protected final IRecipe<?> recipe;
    private final String subType;

    public ActionAddRecipe(IRecipeManager recipeManager, IRecipe<?> recipe, String subType) {
        super(recipeManager);
        this.recipe = recipe;
        this.subType = subType;
    }

    public ActionAddRecipe(IRecipeManager recipeManager, IRecipe<?> recipe) {
        super(recipeManager);
        this.recipe = recipe;
        this.subType = "";
    }

    @Override
    public void apply() {
        Map<ResourceLocation, IRecipe<?>> recipes = this.getManager().getRecipes();
        if (recipes.containsKey(this.recipe.func_199560_c())) {
            CraftTweakerAPI.logWarning("A recipe with the name '%s' already exists and will be overwritten: this is most likely an error in your scripts", this.recipe.func_199560_c().func_110623_a());
        }
        recipes.put(this.recipe.func_199560_c(), this.recipe);
    }

    @Override
    public String describe() {
        return "Adding \"" + this.getManager().getBracketResourceLocation() + "\" recipe" + this.getSubTypeDescription() + ", with name: \"" + this.recipe.func_199560_c() + "\" that outputs: " + this.describeOutputs();
    }

    protected String describeOutputs() {
        return new MCItemStackMutable(this.recipe.func_77571_b()).toString();
    }

    private String getSubTypeDescription() {
        if (this.subType != null && !this.subType.trim().isEmpty()) {
            return ", of type: \"" + this.subType + "\"";
        }
        return "";
    }
}

