/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.crafting.IRecipe;

public class ActionRemoveRecipe
extends ActionRecipeBase {
    protected final Predicate<IRecipe<?>> removePredicate;
    protected Function<ActionRecipeBase, String> describeFunction;

    public ActionRemoveRecipe(IRecipeManager manager, Predicate<IRecipe<?>> removePredicate) {
        super(manager);
        this.removePredicate = removePredicate;
        this.describeFunction = action -> "Removing \"" + this.getRecipeTypeName() + "\" recipes that match a custom condition";
    }

    public ActionRemoveRecipe(IRecipeManager manager, Predicate<IRecipe<?>> removePredicate, Function<ActionRecipeBase, String> describeFunction) {
        super(manager);
        this.removePredicate = removePredicate;
        this.describeFunction = describeFunction;
    }

    @Override
    public void apply() {
        this.getRecipes().keySet().removeIf(location -> this.removePredicate.test(this.getRecipes().get(location)));
    }

    @Override
    public String describe() {
        return this.describeFunction.apply(this);
    }

    public ActionRemoveRecipe describeDefaultRemoval(CommandStringDisplayable output) {
        this.describeFunction = action -> "Removing \"" + action.getRecipeTypeName() + "\" recipes with output: " + output + "\"";
        return this;
    }
}

