/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets.tags;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.impl.brackets.util.ParseUtil;
import com.blamejared.crafttweaker.impl.tag.registry.CrTTagRegistryData;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.ModList;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ZSTokenParser;
import org.openzen.zenscript.parser.BracketExpressionParser;
import org.openzen.zenscript.parser.expression.ParsedCallArguments;
import org.openzen.zenscript.parser.expression.ParsedExpression;
import org.openzen.zenscript.parser.expression.ParsedExpressionCall;
import org.openzen.zenscript.parser.expression.ParsedExpressionMember;
import org.openzen.zenscript.parser.expression.ParsedExpressionVariable;
import org.openzen.zenscript.parser.type.IParsedType;

public class TagManagerBracketHandler
implements BracketExpressionParser {
    private final CrTTagRegistryData tagRegistry;

    public TagManagerBracketHandler(CrTTagRegistryData tagRegistry) {
        this.tagRegistry = tagRegistry;
    }

    @Override
    public ParsedExpression parse(CodePosition position, ZSTokenParser tokens) throws ParseException {
        String tagFolder = ParseUtil.readContent(tokens);
        return this.getParsedExpression(position, tagFolder);
    }

    @Nonnull
    ParsedExpression getParsedExpression(CodePosition position, String tagFolder) throws ParseException {
        this.confirmTagFolderExists(tagFolder, position);
        if (this.tagRegistry.isSynthetic(tagFolder)) {
            return this.createCallSynthetic(tagFolder, position);
        }
        return this.createCallImplementation(tagFolder, position);
    }

    void confirmTagFolderExists(String tagFolder, CodePosition position) throws ParseException {
        if (!this.tagRegistry.hasTagManager(tagFolder)) {
            if (ModList.get().isLoaded(tagFolder)) {
                CraftTweakerAPI.logWarning("Used ModID as tagFolder. The Tag BEP changed from an older version, read the changelog!", new Object[0]);
            }
            throw new ParseException(position, "Could not find tag manager with folder '" + tagFolder + "'. Make sure it exists!");
        }
    }

    private ParsedExpression createCallImplementation(String tagFolder, CodePosition position) {
        ParsedExpressionVariable tags = new ParsedExpressionVariable(position, "tags", null);
        ParsedExpressionMember member = new ParsedExpressionMember(position, tags, "getByImplementation", null);
        String implementationZCTypeFor = this.tagRegistry.getImplementationZCTypeFor(tagFolder);
        List<IParsedType> typeArguments = Collections.singletonList(ParseUtil.readParsedType(implementationZCTypeFor, position));
        ParsedCallArguments arguments = new ParsedCallArguments(typeArguments, Collections.emptyList());
        return new ParsedExpressionCall(position, member, arguments);
    }

    private ParsedExpression createCallSynthetic(String tagFolder, CodePosition position) {
        ParsedExpressionVariable tags = new ParsedExpressionVariable(position, "tags", null);
        ParsedExpressionMember member = new ParsedExpressionMember(position, tags, "getForElementType", null);
        String type = this.tagRegistry.getElementZCTypeFor(tagFolder);
        IParsedType elementType = ParseUtil.readParsedType(type, position);
        List<IParsedType> typeParam = Collections.singletonList(elementType);
        return new ParsedExpressionCall(position, member, new ParsedCallArguments(typeParam, Collections.emptyList()));
    }
}

