/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.events;

import com.blamejared.crafttweaker.CraftTweaker;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.impl.managers.CTCraftingTableManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crafttweaker")
public class CTStateEventHandler {
    private static UpdatedState currentState = UpdatedState.NONE;
    private static RecipeManager manager = null;

    private static void loadScripts() {
        if (((Map)CTStateEventHandler.manager.field_199522_d.getOrDefault(CraftTweaker.RECIPE_TYPE_SCRIPTS, new HashMap())).size() == 0) {
            return;
        }
        CTStateEventHandler.manager.field_199522_d = new HashMap(CTStateEventHandler.manager.field_199522_d);
        CTStateEventHandler.manager.field_199522_d.replaceAll((t, v) -> new HashMap((Map)CTStateEventHandler.manager.field_199522_d.get(t)));
        CraftTweaker.serverOverride = false;
        CTCraftingTableManager.recipeManager = manager;
        ScriptLoadingOptions scriptLoadingOptions = new ScriptLoadingOptions().execute();
        CraftTweakerAPI.loadScriptsFromRecipeManager(manager, scriptLoadingOptions);
    }

    @SubscribeEvent
    public static void onRecipesUpdated(RecipesUpdatedEvent event) {
        if (currentState.hasAll()) {
            currentState = UpdatedState.NONE;
            manager = null;
        }
        manager = event.getRecipeManager();
        if ((currentState = currentState.merge(UpdatedState.RECIPES)).hasAll()) {
            CTStateEventHandler.loadScripts();
            currentState = UpdatedState.NONE;
            manager = null;
        }
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        if (currentState.hasAll()) {
            currentState = UpdatedState.NONE;
            manager = null;
        }
        if ((currentState = currentState.merge(UpdatedState.TAGS)).hasAll()) {
            if (manager == null) {
                throw new RuntimeException("Recipe manager is null in tags updated event, but state has recipes!");
            }
            CTStateEventHandler.loadScripts();
            currentState = UpdatedState.NONE;
            manager = null;
        }
    }

    private static enum UpdatedState {
        NONE(false, false),
        RECIPES(true, false),
        TAGS(false, true),
        ALL(true, true);

        private final boolean hasRecipes;
        private final boolean hasTags;

        private UpdatedState(boolean hasRecipes, boolean hasTags) {
            this.hasRecipes = hasRecipes;
            this.hasTags = hasTags;
        }

        public boolean hasRecipes() {
            return this.hasRecipes;
        }

        public boolean hasTags() {
            return this.hasTags;
        }

        public boolean hasAll() {
            return this.hasRecipes && this.hasTags;
        }

        public static UpdatedState of(boolean hasRecipes, boolean hasTags) {
            if (hasRecipes) {
                if (hasTags) {
                    return ALL;
                }
                return RECIPES;
            }
            if (hasTags) {
                return TAGS;
            }
            return NONE;
        }

        public UpdatedState merge(UpdatedState other) {
            return UpdatedState.of(this.hasRecipes || other.hasRecipes, this.hasTags || other.hasTags);
        }
    }
}

