/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.conditions;

import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientCondition;
import com.blamejared.crafttweaker.api.item.conditions.IIngredientConditionSerializer;
import com.blamejared.crafttweaker.impl.ingredients.conditions.serializer.ConditionDamagedAtLeastSerializer;

public class ConditionDamagedAtLeast<T extends IIngredient>
implements IIngredientCondition<T> {
    private final int minDamage;

    public ConditionDamagedAtLeast(int minDamage) {
        this.minDamage = minDamage;
    }

    @Override
    public boolean matches(IItemStack stack) {
        return stack.getDamage() >= this.minDamage;
    }

    @Override
    public boolean ignoresDamage() {
        return true;
    }

    @Override
    public String getCommandString(IIngredient ingredient) {
        return String.format("%s.onlyDamagedAtLeast(%s)", ingredient.getCommandString(), this.minDamage);
    }

    @Override
    public IIngredientConditionSerializer getSerializer() {
        return ConditionDamagedAtLeastSerializer.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionDamagedAtLeast that = (ConditionDamagedAtLeast)o;
        return this.minDamage == that.minDamage;
    }

    public int hashCode() {
        return this.minDamage;
    }

    public int getMinDamage() {
        return this.minDamage;
    }
}

