/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot.conditions;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.loot.conditions.ILootCondition;
import com.blamejared.crafttweaker.impl.loot.conditions.ILootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.LootConditionManager;
import com.blamejared.crafttweaker.impl.loot.conditions.crafttweaker.AndLootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.crafttweaker.JsonLootConditionTypeBuilder;
import com.blamejared.crafttweaker.impl.loot.conditions.crafttweaker.OrLootConditionTypeBuilder;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.loot.conditions.LootConditionBuilder")
@Document(value="vanilla/api/loot/conditions/LootConditionBuilder")
public final class CTLootConditionBuilder {
    private final List<ILootCondition> conditions = new ArrayList<ILootCondition>();

    private CTLootConditionBuilder() {
    }

    @ZenCodeType.Method
    public static CTLootConditionBuilder create() {
        return new CTLootConditionBuilder();
    }

    @ZenCodeType.Method
    public static CTLootConditionBuilder createInAnd(Consumer<AndLootConditionTypeBuilder> lender) {
        return CTLootConditionBuilder.createForSingle(AndLootConditionTypeBuilder.class, lender);
    }

    @ZenCodeType.Method
    public static CTLootConditionBuilder createInOr(Consumer<OrLootConditionTypeBuilder> lender) {
        return CTLootConditionBuilder.createForSingle(OrLootConditionTypeBuilder.class, lender);
    }

    @ZenCodeType.Method
    public static <T extends ILootConditionTypeBuilder> CTLootConditionBuilder createForSingle(Class<T> reifiedType, Consumer<T> lender) {
        CTLootConditionBuilder base = CTLootConditionBuilder.create();
        base.add(reifiedType, lender);
        return base;
    }

    @ZenCodeType.Method
    public static <T extends ILootConditionTypeBuilder> ILootCondition makeSingle(Class<T> reifiedType, Consumer<T> lender) {
        return CTLootConditionBuilder.createForSingle(reifiedType, lender).single();
    }

    @ZenCodeType.Method
    public static ILootCondition makeJson(ResourceLocation type, IData data) {
        return CTLootConditionBuilder.makeSingle(JsonLootConditionTypeBuilder.class, builder -> builder.withJson(type, data));
    }

    @ZenCodeType.Method
    public static ILootCondition makeJson(String type, IData data) {
        return CTLootConditionBuilder.makeSingle(JsonLootConditionTypeBuilder.class, builder -> builder.withJson(type, data));
    }

    @ZenCodeType.Method
    public <T extends ILootConditionTypeBuilder> CTLootConditionBuilder add(Class<T> reifiedType) {
        return this.add(reifiedType, ignore -> {});
    }

    @ZenCodeType.Method
    public <T extends ILootConditionTypeBuilder> CTLootConditionBuilder add(Class<T> reifiedType, Consumer<T> lender) {
        ILootCondition built = this.make(reifiedType, "main loot builder", lender);
        if (built != null) {
            this.conditions.add(built);
        }
        return this;
    }

    public final <T extends ILootConditionTypeBuilder> ILootCondition make(Class<T> type, String id, Consumer<T> lender) {
        T builder;
        try {
            builder = LootConditionManager.get(this, type);
        }
        catch (ClassCastException | NullPointerException e) {
            CraftTweakerAPI.logThrowing("Unable to create a loot condition builder for type '%s'", e, type.getName());
            return null;
        }
        try {
            lender.accept(builder);
        }
        catch (ClassCastException e) {
            CraftTweakerAPI.logThrowing("Unable to pass a loot condition builder for type '%s' to lender", e, type.getName());
            return null;
        }
        catch (Exception e) {
            CraftTweakerAPI.logThrowing("An error has occurred while populating the builder for type '%s'", e, type.getName());
            return null;
        }
        try {
            return builder.finish();
        }
        catch (IllegalStateException e) {
            CraftTweakerAPI.logThrowing("Unable to add a loot condition of type '%s' to '%s' due to an invalid builder state", e, type.getName(), id);
            return null;
        }
    }

    @ZenCodeType.Method
    public ILootCondition[] build() {
        return this.conditions.toArray(new ILootCondition[0]);
    }

    public ILootCondition single() {
        return this.conditions.size() != 1 ? null : this.conditions.get(0);
    }
}

