/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.tag;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.impl.tag.MCTagWithAmount;
import com.blamejared.crafttweaker.impl.tag.manager.TagManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/tags/MCTag")
@ZenCodeType.Name(value="crafttweaker.api.tag.MCTag")
public final class MCTag<T>
implements CommandStringDisplayable {
    private final ResourceLocation id;
    private final TagManager<T> manager;

    public MCTag(ResourceLocation id, TagManager<T> manager) {
        this.id = id;
        this.manager = manager;
    }

    @SafeVarargs
    @ZenCodeType.Method
    public final void add(T ... items) {
        this.add(Arrays.asList(items));
    }

    @ZenCodeType.Method
    public void add(List<T> items) {
        this.manager.addElements(this, items);
    }

    @ZenCodeType.Method
    public void add(MCTag<T> tag) {
        this.add(tag.getElements());
    }

    @ZenCodeType.Method
    public void addTags(List<MCTag<T>> tags) {
        this.add(tags.stream().flatMap(tag -> tag.getElements().stream()).collect(Collectors.toList()));
    }

    @SafeVarargs
    @ZenCodeType.Method
    public final void remove(T ... items) {
        this.remove(Arrays.asList(items));
    }

    @ZenCodeType.Method
    public void remove(List<T> items) {
        this.manager.removeElements(this, items);
    }

    @ZenCodeType.Method
    public void remove(MCTag<T> tag) {
        this.remove(tag.getElements());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="exists")
    public boolean exists() {
        return this.manager.exists(this.id.toString());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="elements")
    public List<T> getElements() {
        return this.manager.getElementsInTag(this);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="manager")
    public TagManager<T> getManager() {
        return this.manager;
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    public boolean contains(T element) {
        return this.getElements().contains(element);
    }

    @Override
    public String getCommandString() {
        return "<tag:" + this.manager.getTagFolder() + ":" + this.id + ">";
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="id")
    public ResourceLocation getId() {
        return this.id;
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(MCTag<T> other) {
        return this.id.equals((Object)other.id) && this.manager.equals(other.manager);
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public MCTagWithAmount<T> withAmount(int amount) {
        return new MCTagWithAmount(this, amount);
    }

    @ZenCodeType.Method
    @ZenCodeType.Caster(implicit=true)
    public MCTagWithAmount<T> asTagWithAmount() {
        return this.withAmount(1);
    }

    public ResourceLocation getIdInternal() {
        return this.id;
    }

    public ITag<?> getInternal() {
        return this.manager.getInternal(this);
    }

    public final ITag getInternalRaw() {
        return this.getInternal();
    }

    @ZenCodeType.Caster(implicit=true)
    public String toString() {
        return this.getCommandString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCTag mcTag = (MCTag)o;
        if (!this.id.equals((Object)mcTag.id)) {
            return false;
        }
        return this.manager.equals(mcTag.manager);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.manager.hashCode();
        return result;
    }
}

