/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import blusunrize.lib.manual.TextSplitter;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.links.EntryWithLinks;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class ManualEntry
implements Comparable<ManualEntry> {
    private final ManualInstance manual;
    private List<ManualPage> pages;
    private final Function<TextSplitter, EntryData> getContent;
    private String title;
    private String subtext;
    private final ResourceLocation location;
    private Int2ObjectMap<SpecialManualElement> specials;
    private Object2IntMap<String> anchorPoints;
    public static final SpecialManualElement NOT_SPECIAL = new SpecialManualElement(){

        @Override
        public void onOpened(ManualScreen m, int x, int y, List<Button> buttons) {
        }

        @Override
        public int getPixelsTaken() {
            return 0;
        }

        @Override
        public void render(MatrixStack transform, ManualScreen m, int x, int y, int mouseX, int mouseY) {
        }

        @Override
        public void mouseDragged(int x, int y, double clickX, double clickY, double mx, double my, double lastX, double lastY, int mouseButton) {
        }

        @Override
        public boolean listForSearch(String searchTag) {
            return false;
        }

        @Override
        public void recalculateCraftingRecipes() {
        }
    };

    private ManualEntry(ManualInstance m, Function<TextSplitter, EntryData> getContent, ResourceLocation location) {
        this.manual = m;
        this.getContent = getContent;
        this.location = location;
    }

    public void refreshPages() {
        try {
            this.manual.entryRenderPre();
            TextSplitter splitter = new TextSplitter(this.manual);
            EntryData data = this.getContent.apply(splitter);
            this.title = data.title;
            this.subtext = data.subtext;
            EntryWithLinks withLinks = new EntryWithLinks(this.manual.formatText(data.content), this.manual);
            SplitResult result = splitter.split(withLinks.getUnsplitTokens());
            this.specials = result.specialByPage;
            this.anchorPoints = result.pageByAnchor;
            List<List<List<SplitResult.Token>>> text = result.entry;
            this.pages = new ArrayList<ManualPage>(text.size());
            for (int i = 0; i < text.size(); ++i) {
                SpecialManualElement special = (SpecialManualElement)this.specials.get(i);
                if (special == null) {
                    special = NOT_SPECIAL;
                }
                this.pages.add(new ManualPage(text.get(i), special));
            }
            this.manual.entryRenderPost();
        }
        catch (Exception x) {
            throw new RuntimeException("Exception while refreshing manual entry " + this.location + " for manual " + this.manual.getManualName(), x);
        }
    }

    public void renderPage(MatrixStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        int page = gui.page;
        ManualPage toRender = this.pages.get(page);
        int offsetText = 0;
        int n = toRender.renderText.size();
        Objects.requireNonNull(this.manual.fontRenderer());
        int offsetSpecial = (n * 9 + 1 + this.manual.pageHeight - toRender.special.getPixelsTaken()) / 2;
        ManualInstance manual = gui.getManual();
        if (toRender.special.isAbove()) {
            offsetText = toRender.special.getPixelsTaken();
            offsetSpecial = 0;
        }
        ManualUtils.drawSplitString(transform, manual.fontRenderer(), toRender.renderText, x, y + offsetText, manual.getTextColour());
        transform.func_227860_a_();
        transform.func_227861_a_((double)x, (double)(y + offsetSpecial), 0.0);
        toRender.special.render(transform, gui, 0, 0, mouseX, mouseY);
        transform.func_227865_b_();
    }

    public String getTitle() {
        return this.title;
    }

    public Int2ObjectMap<SpecialManualElement> getSpecials() {
        return this.specials;
    }

    public void addButtons(ManualScreen gui, int x, int y, int page, List<Button> pageButtons) {
        ManualPage p = this.pages.get(page);
        p.renderText = p.text.stream().map(l -> l.stream().map(SplitResult.Token::getText).collect(Collectors.joining())).collect(Collectors.toList());
        ManualUtils.addLinkButtons(this, this.manual, gui, p.text, x, y + p.special.getPixelsTaken(), pageButtons);
        ArrayList<Button> tempButtons = new ArrayList<Button>();
        this.pages.get((int)gui.page).special.onOpened(gui, 0, 0, tempButtons);
        for (Button btn : tempButtons) {
            btn.field_230690_l_ += x;
            btn.field_230691_m_ += y;
            pageButtons.add(btn);
        }
    }

    public String getSubtext() {
        return this.subtext;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public ItemStack getHighlightedStack(int page) {
        return this.pages.get((int)page).special.getHighlightedStack();
    }

    public boolean listForSearch(String search) {
        for (ManualPage p : this.pages) {
            if (!p.special.listForSearch(search)) continue;
            return true;
        }
        return false;
    }

    public void mouseDragged(ManualScreen gui, int x, int y, double clickX, double clickY, double mx, double my, double lastX, double lastY, int button) {
        this.pages.get((int)gui.page).special.mouseDragged(x, y, clickX, clickY, mx, my, lastX, lastY, button);
    }

    public int getPageForAnchor(String anchor) {
        return this.anchorPoints.getInt((Object)anchor);
    }

    public boolean hasAnchor(String anchor) {
        return this.anchorPoints.containsKey((Object)anchor);
    }

    public Tree.AbstractNode<ResourceLocation, ManualEntry> getTreeNode() {
        return this.manual.getAllEntriesAndCategories().filter(e -> e.getLeafData() == this).findAny().orElse(null);
    }

    @Override
    public int compareTo(ManualEntry o) {
        return this.title.compareTo(o.title);
    }

    public static class EntryData {
        private final String title;
        private final String subtext;
        private final String content;

        public EntryData(String title, String subtext, String content) {
            this.title = title;
            this.subtext = subtext;
            this.content = content;
        }
    }

    private static class ManualPage {
        public List<String> renderText;
        List<List<SplitResult.Token>> text;
        @Nonnull
        SpecialManualElement special;

        public ManualPage(List<List<SplitResult.Token>> text, @Nonnull SpecialManualElement special) {
            this.text = text;
            this.special = special;
        }
    }

    public static class ManualEntryBuilder {
        ManualInstance manual;
        Function<TextSplitter, EntryData> getContent = null;
        private ResourceLocation location;
        private List<Triple<String, Integer, Supplier<? extends SpecialManualElement>>> hardcodedSpecials = new ArrayList<Triple<String, Integer, Supplier<? extends SpecialManualElement>>>();
        private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

        public ManualEntryBuilder(ManualInstance manual) {
            this.manual = manual;
        }

        public ManualEntryBuilder(@Nonnull ManualInstance manual, @Nonnull TextSplitter splitter) {
            this.manual = manual;
        }

        public void addSpecialElement(String anchor, int offset, Supplier<? extends SpecialManualElement> element) {
            this.hardcodedSpecials.add((Triple<String, Integer, Supplier<? extends SpecialManualElement>>)new ImmutableTriple((Object)anchor, (Object)offset, element));
        }

        public void addSpecialElement(String anchor, int offset, SpecialManualElement element) {
            this.hardcodedSpecials.add((Triple<String, Integer, Supplier<? extends SpecialManualElement>>)new ImmutableTriple((Object)anchor, (Object)offset, () -> element));
        }

        public void setContent(Function<TextSplitter, EntryData> get) {
            this.getContent = splitter -> {
                this.addHardcodedSpecials((TextSplitter)splitter);
                return (EntryData)get.apply((TextSplitter)splitter);
            };
        }

        public void setContent(Supplier<String> title, Supplier<String> subText, Supplier<String> mainText) {
            this.getContent = splitter -> {
                this.addHardcodedSpecials((TextSplitter)splitter);
                return new EntryData((String)title.get(), (String)subText.get(), (String)mainText.get());
            };
        }

        private void addHardcodedSpecials(TextSplitter splitter) {
            for (Triple<String, Integer, Supplier<? extends SpecialManualElement>> special : this.hardcodedSpecials) {
                splitter.addSpecialPage((String)special.getLeft(), (Integer)special.getMiddle(), (SpecialManualElement)((Supplier)special.getRight()).get());
            }
        }

        public void setContent(String title, String subText, String mainText) {
            this.setContent(() -> title, () -> subText, () -> mainText);
        }

        public void appendText(Function<TextSplitter, String> text) {
            Function<TextSplitter, EntryData> old = this.getContent;
            this.setContent(splitter -> {
                EntryData base = (EntryData)old.apply((TextSplitter)splitter);
                return new EntryData(base.title, base.subtext, base.content + (String)text.apply((TextSplitter)splitter));
            });
        }

        public void readFromFile(ResourceLocation name) {
            this.location = name;
            this.getContent = splitter -> {
                IResource resData;
                ResourceLocation langLoc = new ResourceLocation(name.func_110624_b(), "manual/" + Minecraft.func_71410_x().func_135016_M().func_135041_c().getCode() + "/" + name.func_110623_a() + ".txt");
                ResourceLocation dataLoc = new ResourceLocation(name.func_110624_b(), "manual/" + name.func_110623_a() + ".json");
                IResource resLang = ManualEntryBuilder.getResourceNullable(langLoc);
                IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
                try {
                    resData = manager.func_199002_a(dataLoc);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (resLang == null) {
                    resLang = ManualEntryBuilder.getResourceNullable(new ResourceLocation(name.func_110624_b(), "manual/en_us/" + name.func_110623_a() + ".txt"));
                }
                if (resLang == null) {
                    return new EntryData("ERROR", "This is not a good thing", "Could not find the file for " + name);
                }
                try {
                    JsonObject json = (JsonObject)JSONUtils.func_188173_a((Gson)GSON, (Reader)new InputStreamReader(resData.func_199027_b()), JsonObject.class, (boolean)true);
                    byte[] bytesLang = IOUtils.toByteArray((InputStream)resLang.func_199027_b());
                    String content = new String(bytesLang, StandardCharsets.UTF_8);
                    this.addHardcodedSpecials((TextSplitter)splitter);
                    assert (json != null);
                    ManualUtils.parseSpecials(json, splitter, this.manual);
                    int titleEnd = content.indexOf(10);
                    String title = content.substring(0, titleEnd).trim();
                    content = content.substring(titleEnd + 1);
                    int subtitleEnd = content.indexOf(10);
                    String subtext = content.substring(0, subtitleEnd).trim();
                    content = content.substring(subtitleEnd + 1).trim();
                    Pattern backslashNewline = Pattern.compile("[^\\\\][\\\\][\r]?\n[\r]?");
                    String rawText = backslashNewline.matcher(content).replaceAll("").replace("\\\\", "\\");
                    return new EntryData(title, subtext, rawText);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load manual entry from " + name, e);
                }
            };
        }

        public void setLocation(ResourceLocation location) {
            this.location = location;
        }

        public ManualEntry create() {
            Preconditions.checkNotNull((Object)this.manual);
            Preconditions.checkNotNull(this.getContent);
            Preconditions.checkNotNull((Object)this.location);
            return new ManualEntry(this.manual, this.getContent, this.location);
        }

        private static IResource getResourceNullable(ResourceLocation rl) {
            try {
                return Minecraft.func_71410_x().func_195551_G().func_199002_a(rl);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

