/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.math;

import malte0811.modelsplitter.math.Vec3d;

public class EpsilonMath {
    private final double epsilon;

    public EpsilonMath(double epsilon) {
        this.epsilon = epsilon;
    }

    public Sign sign(double firstProduct) {
        if (firstProduct < -this.epsilon) {
            return Sign.NEGATIVE;
        }
        if (firstProduct > this.epsilon) {
            return Sign.POSITIVE;
        }
        return Sign.ZERO;
    }

    public boolean areSame(Vec3d a, Vec3d b) {
        Vec3d diff = a.subtract(b);
        return diff.lengthSquared() < this.epsilon * this.epsilon;
    }

    public int floor(double in) {
        return (int)Math.floor(in + this.epsilon);
    }

    public int ceil(double in) {
        return (int)Math.ceil(in - this.epsilon);
    }

    public static enum Sign {
        POSITIVE,
        ZERO,
        NEGATIVE;


        public Sign invert() {
            switch (this) {
                case POSITIVE: {
                    return NEGATIVE;
                }
                case ZERO: {
                    return ZERO;
                }
                case NEGATIVE: {
                    return POSITIVE;
                }
            }
            throw new IllegalArgumentException("Unknown sign " + (Object)((Object)this));
        }
    }
}

