/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.api.client.hand;

import com.mojang.blaze3d.matrix.MatrixStack;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.api.common.PlacementCorrector;
import me.ichun.mods.ichunutil.api.common.head.HeadInfo;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.HandSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class HandInfo {
    protected static final Logger LOGGER = LogManager.getLogger();
    public String author;
    public String forClass = "THIS SHOULD BE FILLED UP";
    public ModelRendererMarker[] leftHandParts;
    public ModelRendererMarker[] rightHandParts;
    public transient Class<? extends EntityModel> modelClass;

    public boolean setup() {
        if (this.modelClass == null) {
            try {
                Class<?> clz = Class.forName(this.forClass);
                if (!EntityModel.class.isAssignableFrom(clz)) {
                    LOGGER.error("{} does not extend EntityModel!", (Object)clz.getSimpleName());
                    return false;
                }
                this.modelClass = clz;
                if (this.leftHandParts != null) {
                    for (ModelRendererMarker leftHandPart : this.leftHandParts) {
                        if (leftHandPart.setupFields(clz)) continue;
                        return false;
                    }
                }
                if (this.rightHandParts != null) {
                    for (ModelRendererMarker rightHandPart : this.rightHandParts) {
                        if (rightHandPart.setupFields(clz)) continue;
                        return false;
                    }
                }
                return true;
            }
            catch (ClassNotFoundException ignored) {
                return false;
            }
        }
        return true;
    }

    public ModelRenderer[] getHandParts(HandSide side, EntityModel model) {
        ModelRendererMarker[] markers = side == HandSide.LEFT ? this.leftHandParts : this.rightHandParts;
        ModelRenderer[] parts = new ModelRenderer[markers.length];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = markers[i].getModelRenderer(model);
        }
        return parts;
    }

    public MatrixStack[] getPlacementCorrectors(HandSide side) {
        ModelRendererMarker[] markers = side == HandSide.LEFT ? this.leftHandParts : this.rightHandParts;
        MatrixStack[] stacks = new MatrixStack[markers.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = markers[i].getPlacementCorrectorStack();
        }
        return stacks;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelRendererMarker {
        public String fieldName = null;
        public PlacementCorrector[] placementCorrectors;
        private transient Field field;
        private transient ArrayList<Integer> fieldIndices;
        private transient MatrixStack stackPlacementCorrector;

        public boolean setupFields(Class<? extends EntityModel> clz) {
            if (this.field == null) {
                String fieldNameFull;
                String fieldName = fieldNameFull = this.fieldName;
                ArrayList<Integer> indices = new ArrayList<Integer>();
                if (fieldName.contains("[")) {
                    fieldName = fieldNameFull.substring(0, fieldNameFull.indexOf("["));
                    String indicesString = fieldNameFull.substring(fieldNameFull.indexOf("["));
                    while (indicesString.startsWith("[")) {
                        int closeBracketIndex = indicesString.indexOf("]");
                        try {
                            indices.add(Integer.parseInt(indicesString.substring(1, closeBracketIndex)));
                        }
                        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                            LOGGER.error("Error parsing field of {} of model {}", (Object)fieldNameFull, (Object)clz.getSimpleName());
                            return false;
                        }
                        indicesString = indicesString.substring(closeBracketIndex + 1);
                    }
                } else {
                    indices.add(-1);
                }
                Field field = HeadInfo.findField(clz, ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)fieldName));
                if (field != null) {
                    field.setAccessible(true);
                    this.field = field;
                    this.fieldIndices = indices;
                    return true;
                }
                LOGGER.error("Error finding field of {} from {} of model {}", (Object)fieldName, (Object)fieldNameFull, (Object)clz.getSimpleName());
                return false;
            }
            return true;
        }

        public void correctPlacement(MatrixStack stack) {
            if (this.placementCorrectors != null && this.placementCorrectors.length > 0) {
                if (this.stackPlacementCorrector == null) {
                    this.stackPlacementCorrector = new MatrixStack();
                    for (PlacementCorrector renderCorrector : this.placementCorrectors) {
                        renderCorrector.apply(this.stackPlacementCorrector);
                    }
                }
                PlacementCorrector.multiplyStackWithStack(stack, this.stackPlacementCorrector);
            }
        }

        public ModelRenderer getModelRenderer(EntityModel model) {
            try {
                Object o;
                Object modelAtIndex = o = this.field.get(model);
                for (Integer index : this.fieldIndices) {
                    modelAtIndex = HeadInfo.digForModelRendererWithIndex(modelAtIndex, index);
                }
                if (modelAtIndex instanceof ModelRenderer) {
                    return (ModelRenderer)modelAtIndex;
                }
            }
            catch (ArrayIndexOutOfBoundsException | IllegalAccessException | NullPointerException e) {
                LOGGER.error("Error getting model renderer from field {} of class {} in model {}", (Object)this.field.getName(), (Object)this.field.getDeclaringClass().getSimpleName(), (Object)model);
                e.printStackTrace();
            }
            return null;
        }

        public MatrixStack getPlacementCorrectorStack() {
            if (this.placementCorrectors != null && this.placementCorrectors.length > 0) {
                if (this.stackPlacementCorrector == null) {
                    this.stackPlacementCorrector = new MatrixStack();
                    for (PlacementCorrector renderCorrector : this.placementCorrectors) {
                        renderCorrector.apply(this.stackPlacementCorrector);
                    }
                }
                return this.stackPlacementCorrector;
            }
            return null;
        }

        @Nullable
        private ModelRenderer getModel(Field field, ArrayList<Integer> indices, EntityModel model) {
            field.setAccessible(true);
            try {
                Object o;
                Object modelAtIndex = o = field.get(model);
                for (Integer index : indices) {
                    modelAtIndex = HeadInfo.digForModelRendererWithIndex(modelAtIndex, index);
                }
                if (modelAtIndex instanceof ModelRenderer) {
                    return (ModelRenderer)modelAtIndex;
                }
            }
            catch (ArrayIndexOutOfBoundsException | IllegalAccessException | NullPointerException e) {
                LOGGER.error("Error getting hand info of {} for {} in {}", (Object)field.getName(), (Object)field.getDeclaringClass().getSimpleName(), (Object)model);
                e.printStackTrace();
            }
            return null;
        }
    }
}

