/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns;

import com.google.common.base.Splitter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.IWindows;
import me.ichun.mods.ichunutil.client.gui.bns.window.Window;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowDock;
import me.ichun.mods.ichunutil.client.gui.bns.window.WindowGreyout;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.Constraint;
import me.ichun.mods.ichunutil.client.gui.bns.window.constraint.IConstrainable;
import me.ichun.mods.ichunutil.client.render.RenderHelper;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.glfw.GLFW;

public abstract class Workspace
extends Screen
implements IConstrainable,
IWindows {
    public static final long CURSOR_ARROW = GLFW.glfwCreateStandardCursor((int)221185);
    public static final long CURSOR_IBEAM = GLFW.glfwCreateStandardCursor((int)221186);
    public static final long CURSOR_CROSSHAIR = GLFW.glfwCreateStandardCursor((int)221187);
    public static final long CURSOR_HAND = GLFW.glfwCreateStandardCursor((int)221188);
    public static final long CURSOR_HRESIZE = GLFW.glfwCreateStandardCursor((int)221189);
    public static final long CURSOR_VRESIZE = GLFW.glfwCreateStandardCursor((int)221190);
    public static final String ELLIPSIS = "\u2026";
    private static HashMap<Class<?>, Function<Object, List<String>>> OBJECT_INTERPRETER = (HashMap)Util.func_200696_a(new HashMap(), m -> {
        m.put(File.class, o -> {
            File file = (File)o;
            ArrayList<String> info = new ArrayList<String>();
            info.add(file.getName());
            info.add(new SimpleDateFormat().format(new Date(file.lastModified())));
            info.add(IOUtil.readableFileSize(file.length()));
            return info;
        });
        m.put(Theme.class, o -> Collections.singletonList(((Theme)o).name + " - " + ((Theme)o).author));
        m.put(Entity.class, o -> Collections.singletonList(((Entity)o).func_145748_c_().getString()));
        m.put(Class.class, o -> Collections.singletonList(((Class)o).getSimpleName()));
    });
    public int ellipsisLength = 0;
    private Theme theme = Theme.getInstance();
    public ArrayList<Window<?>> windows = new ArrayList();
    private int renderMinecraftStyle;
    private boolean hasInit;
    private Screen lastScreen;
    public String lastTooltip;
    public int tooltipCooldown;
    public long cursorState;

    @Nonnull
    public static List<String> getInterpretedInfo(Object o) {
        Map.Entry<Class<?>, Function<Object, List<String>>> lastEntryUsed = null;
        List<String> infos = null;
        for (Map.Entry<Class<?>, Function<Object, List<String>>> e : OBJECT_INTERPRETER.entrySet()) {
            if (!e.getKey().isInstance(o) || lastEntryUsed != null && e.getKey().isAssignableFrom(lastEntryUsed.getKey())) continue;
            lastEntryUsed = e;
            infos = e.getValue().apply(o);
        }
        if (infos == null) {
            infos = new ArrayList<String>();
            infos.add(o.toString());
        }
        return infos;
    }

    public static void registerObjectInterpreter(Class<?> clz, Function<Object, List<String>> function) {
        OBJECT_INTERPRETER.put(clz, function);
    }

    public Workspace(Screen lastScreen, ITextComponent title, int mcStyle) {
        super(title);
        this.lastScreen = lastScreen;
        this.renderMinecraftStyle = mcStyle;
        if (this.canDockWindows()) {
            this.windows.add(new WindowDock<Workspace>(this));
        }
    }

    public <T extends Workspace> T setLastScreen(Screen screen) {
        this.lastScreen = screen;
        return (T)this;
    }

    public <T extends Workspace> T setTheme(Theme theme) {
        this.theme = theme;
        return (T)this;
    }

    public <T extends Workspace> T setMinecraftStyle(int i) {
        this.renderMinecraftStyle = i;
        return (T)this;
    }

    @Override
    public int getWidth() {
        return this.field_230708_k_;
    }

    @Override
    public int getHeight() {
        return this.field_230709_l_;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    protected void func_231160_c_() {
        if (!this.hasInit) {
            this.hasInit = true;
            this.ellipsisLength = this.getFontRenderer().func_78256_a(ELLIPSIS);
            this.windows.forEach((Consumer<Window<?>>)((Consumer<Window>)Fragment::init));
        }
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public boolean hasInit() {
        return this.hasInit;
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        GLFW.glfwSetCursor((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (long)0L);
    }

    public List<Window<?>> func_231039_at__() {
        if (this.canDockWindows()) {
            ArrayList winds = new ArrayList();
            for (int i = 0; i < this.windows.size(); ++i) {
                Window<?> window = this.windows.get(i);
                if (window instanceof WindowDock) {
                    ((WindowDock)window).docked.keySet().forEach(h -> winds.addAll(h.windows));
                    continue;
                }
                winds.add(window);
            }
            winds.remove(this.getDock());
            return winds;
        }
        return this.windows;
    }

    @Override
    public Window<?> addWindow(Window<?> window) {
        if (window.isUnique()) {
            List<Window<?>> allWindows = this.func_231039_at__();
            for (int i = allWindows.size() - 1; i >= 0; --i) {
                Window<?> window1 = allWindows.get(i);
                if (window1.getClass() != window.getClass()) continue;
                if (this.isDocked(window1)) {
                    window1.onClose();
                    this.getDock().removeFromDock(window1);
                    continue;
                }
                this.removeWindow(window1);
            }
        }
        this.windows.add(0, window);
        return window;
    }

    @Override
    public void removeWindow(Window<?> window) {
        if (this.func_241217_q_() == window) {
            this.func_231035_a_(null);
        }
        window.onClose();
        this.windows.remove(window);
    }

    public void bringToFront(Window<?> window) {
        if (window.canBringToFront() && this.windows.remove(window)) {
            this.addWindow(window);
        }
    }

    public void putInCenter(Window<?> window) {
        if (!this.isDocked(window)) {
            window.pos((int)((double)(this.getWidth() - window.getWidth()) / 2.0), (int)((double)(this.getHeight() - window.getHeight()) / 2.0));
        }
    }

    public void openWindowInCenter(Window<?> window, double widthRatio, double heightRatio, boolean greyout) {
        if (widthRatio <= 1.0) {
            window.setWidth((int)((double)window.getParentWidth() * widthRatio));
        } else {
            window.setWidth((int)widthRatio);
        }
        if (heightRatio <= 1.0) {
            window.setHeight((int)((double)window.getParentHeight() * heightRatio));
        } else {
            window.setHeight((int)heightRatio);
        }
        if (greyout) {
            this.addWindowWithGreyout(window);
        } else {
            this.addWindow(window);
        }
        this.putInCenter(window);
        this.func_231035_a_((IGuiEventListener)window);
        window.init();
    }

    public void openWindowInCenter(Window<?> window, double widthRatio, double heightRatio) {
        this.openWindowInCenter(window, widthRatio, heightRatio, false);
    }

    public void openWindowInCenter(Window<?> window, boolean greyout) {
        this.openWindowInCenter(window, 0.5, 0.5, greyout);
    }

    public void openWindowInCenter(Window<?> window) {
        this.openWindowInCenter(window, false);
    }

    public void addWindowWithGreyout(Window<?> window) {
        WindowGreyout<Workspace> greyout = new WindowGreyout<Workspace>(this, window);
        this.addWindow(greyout);
        greyout.init();
        this.addWindow(window);
    }

    public void func_231023_e_() {
        this.func_231039_at__().forEach(Fragment::tick);
        --this.tooltipCooldown;
    }

    @Nullable
    public <T extends Fragment<?>> T getById(@Nonnull String id) {
        T o = null;
        for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
            if (o != null || !(iGuiEventListener instanceof Fragment)) continue;
            o = ((Fragment)iGuiEventListener).getById(id);
        }
        return o;
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        this.cursorState = CURSOR_ARROW;
        stack.func_227860_a_();
        RenderSystem.enableAlphaTest();
        this.func_230446_a_(stack);
        this.renderWindows(stack, mouseX, mouseY, partialTick);
        this.renderTooltip(stack, mouseX, mouseY, partialTick);
        this.resetBackground();
        RenderSystem.enableAlphaTest();
        stack.func_227865_b_();
        GLFW.glfwSetCursor((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (long)this.cursorState);
    }

    public void renderWindows(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window<?> window = this.windows.get(i);
            stack.func_227861_a_(0.0, 0.0, 10.0);
            window.func_230430_a_(stack, mouseX, mouseY, partialTick);
        }
    }

    public void renderTooltip(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        Fragment<?> topMost = this.getTopMostFragment(mouseX, mouseY);
        if (topMost != null) {
            String tooltip = topMost.tooltip(mouseX, mouseY);
            if (tooltip != null) {
                if (!tooltip.equals(this.lastTooltip)) {
                    this.lastTooltip = tooltip;
                    this.tooltipCooldown = iChunUtil.configClient.guiTooltipCooldown;
                }
            } else {
                this.lastTooltip = null;
            }
        }
        if (this.lastTooltip != null && this.tooltipCooldown < 0) {
            this.renderTooltip(stack, this.lastTooltip, mouseX, mouseY);
        }
    }

    public void renderTooltip(MatrixStack stack, @Nonnull String tooltip, int mouseX, int mouseY) {
        List textStrings = Splitter.on((String)"\n").splitToList((CharSequence)tooltip);
        if (this.renderMinecraftStyle > 0) {
            ArrayList<StringTextComponent> textLines = new ArrayList<StringTextComponent>();
            for (String s : textStrings) {
                textLines.add(new StringTextComponent(s));
            }
            super.func_243308_b(stack, textLines, mouseX, mouseY);
        } else {
            int n;
            ArrayList<StringTextComponent> textLines = new ArrayList<StringTextComponent>();
            for (String s : textStrings) {
                textLines.add(new StringTextComponent(s));
            }
            ItemStack itemstack = ItemStack.field_190927_a;
            int screenWidth = this.field_230708_k_;
            int screenHeight = this.field_230709_l_;
            int maxTextWidth = -1;
            FontRenderer font = this.getFontRenderer();
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(itemstack, textLines, stack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (ITextProperties iTextProperties : textLines) {
                int textLineWidth = font.func_238414_a_(iTextProperties);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
                for (int i = 0; i < textLines.size(); ++i) {
                    ITextProperties textLine = (ITextProperties)textLines.get(i);
                    List wrappedLine = font.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (ITextProperties line : wrappedLine) {
                        int lineWidth = font.func_238414_a_(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 400;
            stack.func_227860_a_();
            Matrix4f mat = stack.func_227866_c_().func_227870_a_();
            RenderHelper.drawColour(stack, this.getTheme().windowBorder[0], this.getTheme().windowBorder[1], this.getTheme().windowBorder[2], 255, tooltipX - 3, tooltipY - 3, tooltipTextWidth + 6, tooltipHeight + 6, 400.0);
            RenderHelper.drawColour(stack, this.getTheme().windowBackground[0], this.getTheme().windowBackground[1], this.getTheme().windowBackground[2], 255, tooltipX - 2, tooltipY - 2, tooltipTextWidth + 4, tooltipHeight + 4, 400.0);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(itemstack, textLines, stack, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
            IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            stack.func_227861_a_(0.0, 0.0, 400.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                ITextProperties line = (ITextProperties)textLines.get(lineNumber);
                if (line != null) {
                    font.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.func_228461_a_();
            stack.func_227865_b_();
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(itemstack, textLines, stack, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            RenderSystem.enableDepthTest();
        }
    }

    @Nullable
    public Fragment<?> getTopMostFragment(double mouseX, double mouseY) {
        Fragment<?> o = null;
        List<Window<?>> children = this.func_231039_at__();
        for (int i = children.size() - 1; i >= 0; --i) {
            Fragment<?> o1 = children.get(i).getTopMostFragment(mouseX, mouseY);
            if (o1 == null) continue;
            o = o1;
        }
        return o;
    }

    public void func_231152_a_(Minecraft mc, int width, int height) {
        this.field_230706_i_ = mc;
        this.field_230707_j_ = mc.func_175599_af();
        this.field_230712_o_ = mc.field_71466_p;
        this.field_230708_k_ = width;
        this.field_230709_l_ = height;
        this.func_231035_a_(null);
        this.windows.forEach((Consumer<Window<?>>)((Consumer<Window>)window -> window.resize(mc, width, height)));
    }

    public void func_230446_a_(MatrixStack stack) {
        if (this.renderMinecraftStyle > 0) {
            super.func_230446_a_(stack);
        } else {
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)((double)this.field_230706_i_.func_228018_at_().func_198109_k() / this.field_230706_i_.func_228018_at_().func_198100_s()), (double)((double)this.field_230706_i_.func_228018_at_().func_198091_l() / this.field_230706_i_.func_228018_at_().func_198100_s()), (double)0.0, (double)-5000.0, (double)5000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.clearColor((float)((float)this.getTheme().workspaceBackground[0] / 255.0f), (float)((float)this.getTheme().workspaceBackground[1] / 255.0f), (float)((float)this.getTheme().workspaceBackground[2] / 255.0f), (float)255.0f);
            RenderSystem.clear((int)16640, (boolean)Minecraft.field_142025_a);
        }
        RenderSystem.pushMatrix();
    }

    public void resetBackground() {
        RenderSystem.popMatrix();
        if (this.renderMinecraftStyle == 0) {
            RenderSystem.matrixMode((int)5889);
            RenderSystem.loadIdentity();
            RenderSystem.ortho((double)0.0, (double)((double)this.field_230706_i_.func_228018_at_().func_198109_k() / this.field_230706_i_.func_228018_at_().func_198100_s()), (double)((double)this.field_230706_i_.func_228018_at_().func_198091_l() / this.field_230706_i_.func_228018_at_().func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.loadIdentity();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        }
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    @Override
    public int renderMinecraftStyle() {
        return this.renderMinecraftStyle;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double distX, double distY) {
        return super.func_231045_a_(mouseX, mouseY, button, distX, distY);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.func_231037_b__(false);
        return this.func_241217_q_() != null && this.func_241217_q_().func_231048_c_(mouseX, mouseY, button);
    }

    @Override
    public boolean isObstructed(Window<?> window, double mouseX, double mouseY) {
        for (Window<?> window1 : this.func_231039_at__()) {
            if (!Fragment.isMouseBetween(mouseX, window1.getLeft(), window1.getLeft() + window1.width) || !Fragment.isMouseBetween(mouseY, window1.getTop(), window1.getTop() + window1.height)) continue;
            return window != window1;
        }
        return true;
    }

    public <T extends Window<?>> T getByWindowType(Class<T> clz) {
        List<Window<?>> windows = this.func_231039_at__();
        for (Window<?> window : windows) {
            if (!clz.isAssignableFrom(window.getClass())) continue;
            return (T)window;
        }
        return null;
    }

    @Override
    public boolean canDockWindows() {
        return true;
    }

    public WindowDock<? extends Workspace> getDock() {
        return (WindowDock)this.windows.get(this.windows.size() - 1);
    }

    @Override
    public IWindows.DockInfo getDockInfo(double mouseX, double mouseY, boolean dockStack) {
        if (this.canDockWindows()) {
            return this.getDock().getDockInfo(mouseX, mouseY, dockStack);
        }
        return null;
    }

    @Override
    public void addToDocked(Window<?> docked, Window<?> window) {
        if (this.canDockWindows() && this.getDock().addToDocked(docked, window)) {
            this.removeWindow(window);
        }
    }

    @Override
    public void addToDock(Window<?> window, Constraint.Property.Type type) {
        if (this.canDockWindows()) {
            this.getDock().addToDock(window, type);
            this.removeWindow(window);
        }
    }

    @Override
    public void removeFromDock(Window<?> window) {
        if (this.canDockWindows()) {
            this.getDock().removeFromDock(window);
            this.addWindow(window);
        }
    }

    @Override
    public boolean isDocked(Window<?> window) {
        if (this.canDockWindows()) {
            return this.getDock().isDocked(window);
        }
        return false;
    }

    @Override
    public boolean sameDockStack(IConstrainable window, IConstrainable window1) {
        if (this.canDockWindows()) {
            return this.getDock().sameDockStack(window, window1);
        }
        return false;
    }

    public void func_231035_a_(@Nullable IGuiEventListener gui) {
        IGuiEventListener lastFocused = this.func_241217_q_();
        if (lastFocused instanceof Fragment && gui != lastFocused) {
            ((Fragment)lastFocused).unfocus(gui);
        }
        if (gui instanceof Window) {
            this.bringToFront((Window)gui);
        }
        super.func_231035_a_(gui);
    }

    @Override
    public int getLeft() {
        return 0;
    }

    @Override
    public int getRight() {
        return this.field_230708_k_;
    }

    @Override
    public int getTop() {
        return 0;
    }

    @Override
    public int getBottom() {
        return this.field_230709_l_;
    }

    public static void bindTexture(ResourceLocation rl) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
    }
}

