/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.gui.bns.window.view.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.ichun.mods.ichunutil.client.gui.bns.Workspace;
import me.ichun.mods.ichunutil.client.gui.bns.window.Fragment;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.Element;
import me.ichun.mods.ichunutil.common.iChunUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class ElementTextField
extends Element {
    public static final Predicate<String> INTEGERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains(".")) {
                return false;
            }
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> NUMBERS = s -> {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            if (s.contains("f") || s.contains("d") || s.contains("F") || s.contains("D")) {
                return false;
            }
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    };
    public static final Predicate<String> FILE_SAFE = s -> {
        String[] invalidChars;
        if (s.isEmpty()) {
            return true;
        }
        for (String c : invalidChars = new String[]{"\\", "/", ":", "*", "?", "\"", "<", ">", "|"}) {
            if (!s.contains(c)) continue;
            return false;
        }
        return !s.startsWith(".");
    };
    protected TextFieldWidget widget;
    private String defaultText = "";
    private int maxStringLength = Short.MAX_VALUE;
    private Predicate<String> validator = s -> true;
    private BiFunction<String, Integer, IReorderingProcessor> textFormatter = (s, cursorPos) -> IReorderingProcessor.func_242239_a((String)s, (Style)Style.field_240709_b_);
    @Nullable
    private Consumer<String> responder;
    @Nullable
    private Consumer<String> enterResponder;
    private int lastLeft;
    private int lastTop;

    public ElementTextField(@Nonnull Fragment parent) {
        super(parent);
    }

    public <T extends ElementTextField> T setDefaultText(String s) {
        this.defaultText = s;
        return (T)this;
    }

    public <T extends ElementTextField> T setValidator(Predicate<String> validator) {
        this.validator = validator;
        return (T)this;
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public <T extends ElementTextField> T setResponder(Consumer<String> responder) {
        this.responder = responder;
        return (T)this;
    }

    public Consumer<String> getResponder() {
        return this.responder;
    }

    public <T extends ElementTextField> T setEnterResponder(Consumer<String> responder) {
        this.enterResponder = responder;
        return (T)this;
    }

    public <T extends ElementTextField> T setMaxStringLength(int i) {
        this.maxStringLength = i;
        return (T)this;
    }

    public <T extends ElementTextField> T setTextFormatter(BiFunction<String, Integer, IReorderingProcessor> textFormatter) {
        this.textFormatter = textFormatter;
        return (T)this;
    }

    @Override
    public void init() {
        super.init();
        this.widget = new TextFieldWidget(this.getFontRenderer(), this.getLeft(), this.getTop(), this.width, this.height, (ITextComponent)new TranslationTextComponent("gui.ichunutil.element.textField"));
        this.widget.func_146203_f(this.maxStringLength);
        this.widget.func_146180_a(this.defaultText);
        this.widget.func_200675_a(this.validator);
        this.widget.func_212954_a(this.responder);
        this.widget.func_195607_a(this.textFormatter);
        this.adjustWidget();
        this.lastLeft = this.getLeft();
        this.lastTop = this.getTop();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.widget != null) {
            this.widget.func_146178_a();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            ((Workspace)this.getWorkspace()).cursorState = Workspace.CURSOR_IBEAM;
        }
        if (this.lastLeft != this.getLeft() || this.lastTop != this.getTop()) {
            this.adjustWidget();
            this.lastLeft = this.getLeft();
            this.lastTop = this.getTop();
        }
        this.drawTextBox(stack, mouseX, mouseY, partialTick);
    }

    public void drawTextBox(MatrixStack stack, int mouseX, int mouseY, float partialTick) {
        if (this.renderMinecraftStyle() > 0) {
            this.widget.func_146185_a(true);
            this.widget.func_230430_a_(stack, mouseX, mouseY, partialTick);
        } else {
            int[] colour = this.func_231047_b_(mouseX, mouseY) ? this.getTheme().elementInputBackgroundHover : this.getTheme().elementInputBackgroundInactive;
            this.fill(stack, this.getTheme().elementInputBorder, 0);
            this.fill(stack, colour, 1);
            this.widget.func_146185_a(false);
            this.widget.func_230430_a_(stack, mouseX, mouseY, partialTick);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void resize(Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
        this.adjustWidget();
    }

    public void adjustWidget() {
        if (this.widget != null) {
            if (this.renderMinecraftStyle() > 0) {
                this.widget.field_230690_l_ = this.getLeft() + 1;
                this.widget.field_230691_m_ = this.getTop() + 1;
                this.widget.func_230991_b_(this.width - 2);
                this.widget.setHeight(this.height - 2);
            } else {
                this.widget.field_230690_l_ = this.getLeft() + 5;
                int n = this.getTop() + 1;
                this.getFontRenderer().getClass();
                this.widget.field_230691_m_ = n + (this.height - 9) / 2;
                this.widget.func_230991_b_(this.width - 6);
                this.widget.setHeight(this.height - 2);
            }
        }
    }

    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        boolean flag = super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        if ((keyCode == 257 || keyCode == 335) && this.enterResponder != null) {
            this.enterResponder.accept(this.getText());
        }
        return flag;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.func_231035_a_((IGuiEventListener)this.widget);
            this.widget.func_146195_b(true);
            if (button == 1) {
                this.widget.func_146180_a("");
            } else if (button == 2) {
                this.widget.func_146191_b(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            }
            this.widget.func_231044_a_(mouseX, mouseY, button);
            return true;
        }
        return false;
    }

    @Override
    public void unfocus(@Nullable IGuiEventListener guiReplacing) {
        super.unfocus(guiReplacing);
        this.widget.func_146195_b(false);
        this.func_231035_a_(null);
    }

    @Override
    public boolean func_231049_c__(boolean direction) {
        if (this.parentFragment.func_241217_q_() != this) {
            this.func_231035_a_((IGuiEventListener)this.widget);
            this.widget.func_146195_b(true);
            return true;
        }
        return false;
    }

    public void setText(@Nonnull String s) {
        if (this.widget == null) {
            iChunUtil.LOGGER.error("You're trying to set a text field widget whilst it is still null. Use setDefaultText instead");
            return;
        }
        this.widget.func_146180_a(s);
    }

    public String getText() {
        return this.widget.func_146179_b();
    }

    public TextFieldWidget getTextField() {
        return this.widget;
    }

    @Override
    public int getMinHeight() {
        return 12;
    }
}

