/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.key;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyBind {
    @Nonnull
    public final KeyBinding keyBinding;
    @Nullable
    public final Consumer<KeyBind> pressConsumer;
    @Nullable
    public final Consumer<KeyBind> releaseConsumer;
    @Nullable
    public Consumer<KeyBind> tickConsumer;
    public boolean pressed = false;
    public int pressTime = 0;
    public boolean holdable = false;
    public int holdTime = 0;

    public KeyBind(KeyBinding keyBinding, @Nullable Consumer<KeyBind> pressConsumer, @Nullable Consumer<KeyBind> releaseConsumer) {
        this.keyBinding = keyBinding;
        this.pressConsumer = pressConsumer;
        this.releaseConsumer = releaseConsumer;
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBinding);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
    }

    public KeyBind setTickConsumer(Consumer<KeyBind> tickConsumer) {
        this.tickConsumer = tickConsumer;
        return this;
    }

    public KeyBind setHoldable() {
        this.holdable = true;
        return this;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (this.pressed) {
                ++this.pressTime;
                if (!this.keyBinding.func_151470_d()) {
                    this.pressed = false;
                    this.holdTime = 0;
                    if (this.releaseConsumer != null) {
                        this.releaseConsumer.accept(this);
                    }
                } else {
                    if (this.tickConsumer != null) {
                        this.tickConsumer.accept(this);
                    }
                    if (this.holdTime > 0) {
                        --this.holdTime;
                        if (this.holdTime == 0) {
                            this.holdTime = 5;
                            if (this.pressConsumer != null) {
                                this.pressConsumer.accept(this);
                            }
                        }
                    }
                }
            } else {
                this.pressTime = 0;
                if (this.keyBinding.func_151470_d()) {
                    this.pressed = true;
                    if (this.pressConsumer != null) {
                        this.pressConsumer.accept(this);
                    }
                    if (this.holdable) {
                        this.holdTime = 20;
                    }
                }
            }
        }
    }

    public static enum ConflictContext implements IKeyConflictContext
    {
        IN_GAME_MODIFIER_SENSITIVE{

            public boolean isActive() {
                return !KeyConflictContext.GUI.isActive();
            }

            public boolean conflicts(IKeyConflictContext other) {
                return this == other;
            }
        };

    }
}

