/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.common.config;

import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.client.gui.bns.window.view.element.ElementList;
import me.ichun.mods.ichunutil.client.gui.config.WorkspaceConfigs;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.ObfHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public abstract class ConfigBase
implements Comparable<ConfigBase> {
    @Prop
    public static final Set<ConfigBase> CONFIGS = Collections.synchronizedSet(new TreeSet(Comparator.naturalOrder()));
    public static final HashMap<String, BiFunction<WorkspaceConfigs.ConfigInfo.ValueWrapperLocalised, ElementList.Item<?>, Boolean>> GUI_ELEMENT_OVERRIDES = new HashMap();
    @Nonnull
    private final String fileName;
    @Nonnull
    public final TreeMap<String, HashSet<ValueWrapper<?>>> values = new TreeMap(Ordering.natural());
    private boolean init;
    private ModConfig config;

    public ConfigBase() {
        this(ModLoadingContext.get().getActiveContainer().getModId() + ".toml");
    }

    public ConfigBase(@Nonnull String fileName) {
        this.fileName = fileName;
        CONFIGS.add(this);
    }

    public <T extends ConfigBase> T init() {
        this.init = true;
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        Field[] fields = this.getClass().getDeclaredFields();
        String[] lastCat = new String[]{""};
        for (Field field : fields) {
            field.setAccessible(true);
            if (Modifier.isTransient(field.getModifiers()) || !ConfigBase.isValidField(field)) continue;
            this.createWrapper(field, configBuilder, lastCat);
        }
        if (!lastCat[0].isEmpty()) {
            configBuilder.pop();
        }
        this.buildAdditionalConfigs(configBuilder);
        this.config = new ModConfig(this.getConfigType(), configBuilder.build(), ModLoadingContext.get().getActiveContainer(), this.fileName);
        ModLoadingContext.get().getActiveContainer().addConfig(this.config);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
        this.loadConfig();
        return (T)this;
    }

    public void buildAdditionalConfigs(ForgeConfigSpec.Builder builder) {
    }

    private void loadConfig() {
        if (iChunUtil.getLoadingStage().ordinal() > ModLoadingStage.CONSTRUCT.ordinal() && this.getConfigType() != ModConfig.Type.SERVER) {
            iChunUtil.LOGGER.info("Missed config load window. Force loading config: {}", (Object)this.fileName);
            try {
                Method method = ConfigTracker.class.getDeclaredMethod("openConfig", ModConfig.class, Path.class);
                method.setAccessible(true);
                method.invoke((Object)ConfigTracker.INSTANCE, this.config, FMLPaths.CONFIGDIR.get());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                iChunUtil.LOGGER.fatal("Uh oh. We failed to load the config. This is bad. CRASH!");
                throw new RuntimeException(e);
            }
        }
    }

    private void createWrapper(Field field, ForgeConfigSpec.Builder builder, String[] lastCat) {
        Method method;
        Object o;
        if (field.isAnnotationPresent(CategoryDivider.class)) {
            CategoryDivider divider = field.getAnnotation(CategoryDivider.class);
            if (divider.name().isEmpty()) {
                throw new RuntimeException("WHY are you defining AN EMPTY CATEGORY?!");
            }
            if (!lastCat[0].isEmpty()) {
                builder.pop();
            }
            lastCat[0] = divider.name();
            if (!divider.comment().equals("undefined")) {
                builder.comment(divider.comment());
            } else if (divider.name().equals("general")) {
                builder.comment("These options are general options that don't fit any other category.");
            } else if (divider.name().equals("gameplay")) {
                builder.comment("These options affect the gameplay while using the mod.");
            } else if (divider.name().equals("global")) {
                builder.comment("These options affect both servers and clients that load the mod.");
            } else if (divider.name().equals("serverOnly")) {
                builder.comment("These options affect only the server that loads the mod.");
            } else if (divider.name().equals("clientOnly")) {
                builder.comment("These options affect only the client that loads the mod.");
            } else if (divider.name().equals("block")) {
                builder.comment("These options affect the blocks in the mod.");
            }
            builder.push(lastCat[0]);
        }
        try {
            o = field.get(this);
        }
        catch (IllegalAccessException e) {
            return;
        }
        String fieldName = field.getName();
        Class<?> clz = field.getType();
        Prop props = field.isAnnotationPresent(Prop.class) ? field.getAnnotation(Prop.class) : ConfigBase.class.getDeclaredFields()[0].getAnnotation(Prop.class);
        if (!props.comment().equals("undefined")) {
            builder.comment(props.comment());
        } else {
            boolean hasComment = false;
            try (InputStream in = this.getClass().getResourceAsStream("/assets/" + this.getModId() + "/lang/en_us.json");){
                Map localization = (Map)new Gson().fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), new TypeToken<Map<String, String>>(){}.getType());
                String commentKey = "config." + this.getModId() + ".prop." + fieldName + ".desc";
                if (localization.containsKey(commentKey)) {
                    hasComment = true;
                    builder.comment((String)localization.get(commentKey));
                }
            }
            catch (IOException e) {
                iChunUtil.LOGGER.warn("Error getting localization for config {} is not commented: {}", (Object)this.getConfigName(), (Object)fieldName);
                e.printStackTrace();
            }
            if (!hasComment && ObfHelper.isDevEnvironment()) {
                iChunUtil.LOGGER.warn("Property from {} is not commented: {}", (Object)this.getConfigName(), (Object)fieldName);
            }
        }
        builder.translation("config." + this.getModId() + ".prop." + fieldName + ".desc");
        ForgeConfigSpec.BooleanValue value = null;
        if (props.needsRestart()) {
            builder.worldRestart();
        }
        if (clz == Integer.TYPE) {
            value = builder.defineInRange(fieldName, ((Integer)o).intValue(), props.min() == Double.MIN_VALUE ? Integer.MIN_VALUE : (int)props.min(), props.max() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)props.max());
        } else if (clz == Double.TYPE) {
            value = builder.defineInRange(fieldName, ((Double)o).doubleValue(), props.min(), props.max());
        } else if (clz == Boolean.TYPE) {
            value = builder.define(fieldName, ((Boolean)o).booleanValue());
        } else if (clz == String.class) {
            if (props.values().length != 1 || !props.values()[0].isEmpty()) {
                value = builder.defineInList(fieldName, (Object)((String)o), Arrays.asList(props.values()));
            } else if (props.validator().equals("undefined") || props.validator().isEmpty()) {
                value = builder.define(fieldName, (Object)((String)o));
            } else {
                try {
                    method = this.getClass().getDeclaredMethod(props.validator(), Object.class);
                    method.setAccessible(true);
                    value = builder.define(fieldName, (Object)((String)o), x -> {
                        try {
                            return (Boolean)method.invoke((Object)this, x);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("Can't find proper validator \"" + props.validator() + "\" for field " + fieldName);
                        }
                    });
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        } else if (clz.isEnum()) {
            value = builder.defineEnum(fieldName, (Enum)o);
        } else if (o instanceof List) {
            if (props.validator().equals("undefined") || props.validator().isEmpty()) {
                value = builder.defineList(fieldName, (List)o, x -> true);
            } else {
                try {
                    method = this.getClass().getDeclaredMethod(props.validator(), Object.class);
                    method.setAccessible(true);
                    value = builder.defineList(fieldName, (List)o, x -> {
                        try {
                            return (Boolean)method.invoke((Object)this, x);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("Can't find proper validator \"" + props.validator() + "\" for field " + fieldName);
                        }
                    });
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        if (value == null) {
            throw new RuntimeException("Value should never be null");
        }
        HashSet vals = this.values.computeIfAbsent(lastCat[0], v -> new HashSet());
        vals.add(new ValueWrapper(this, (ForgeConfigSpec.ConfigValue)value, field));
    }

    @Nonnull
    public abstract String getModId();

    @Nonnull
    public abstract String getConfigName();

    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.COMMON;
    }

    private void onConfigLoad(ModConfig.Loading event) {
        if (event.getConfig().getFileName().equals(this.fileName)) {
            this.checkForChanges();
            this.onConfigLoaded();
        }
    }

    private void onConfigReload(ModConfig.Reloading event) {
        if (event.getConfig().getFileName().equals(this.fileName)) {
            this.checkForChanges();
            this.onConfigLoaded();
        }
    }

    public void onPropertyChanged(boolean file, String name, Field field, Object oldObj, Object newObj) {
    }

    public void onConfigLoaded() {
    }

    private void checkForChanges() {
        for (HashSet<ValueWrapper<?>> vals : this.values.values()) {
            vals.forEach(rec$ -> ((ValueWrapper)rec$).checkForChange());
        }
    }

    public boolean hasInit() {
        return this.init;
    }

    public void save() {
        boolean save = false;
        for (HashSet<ValueWrapper<?>> vals : this.values.values()) {
            for (ValueWrapper<?> value : vals) {
                save = ((ValueWrapper)value).save() || save;
            }
        }
        if (save) {
            this.config.getSpec().save();
            this.onConfigLoaded();
        }
    }

    @Override
    public int compareTo(ConfigBase o) {
        if (this.getConfigName().equals(o.getConfigName())) {
            return Integer.compare(this.getConfigType().ordinal(), o.getConfigType().ordinal());
        }
        return this.getConfigName().compareTo(o.getConfigName());
    }

    private static boolean isValidField(Field field) {
        return field.isAnnotationPresent(Prop.class) || field.getType() == Integer.TYPE || field.getType() == Double.TYPE || field.getType() == Boolean.TYPE || field.getType() == String.class || field.getType().isEnum() || List.class.isAssignableFrom(field.getType());
    }

    public static class ValueWrapper<T> {
        public final ConfigBase parent;
        @Nonnull
        private final ForgeConfigSpec.ConfigValue<T> configValue;
        @Nonnull
        public final Field field;
        private T lastObj = null;

        private ValueWrapper(ConfigBase config, ForgeConfigSpec.ConfigValue<T> configValue, Field field) {
            this.parent = config;
            this.configValue = configValue;
            this.field = field;
        }

        private void checkForChange() {
            if (!this.configValue.get().equals(this.lastObj)) {
                try {
                    T old = this.lastObj;
                    this.lastObj = this.configValue.get();
                    this.field.setAccessible(true);
                    this.field.set(this.parent, this.lastObj);
                    this.parent.onPropertyChanged(true, this.field.getName(), this.field, old, this.lastObj);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        private boolean save() {
            try {
                this.field.setAccessible(true);
                Object o = this.field.get(this.parent);
                if (this.lastObj != null && !o.equals(this.lastObj)) {
                    T old = this.lastObj;
                    this.lastObj = o;
                    this.configValue.set(this.lastObj);
                    this.parent.onPropertyChanged(false, this.field.getName(), this.field, old, this.lastObj);
                    return true;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

