/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public class CyclopsTileEntity
extends TileEntity
implements INBTProvider,
IDirtyMarkListener {
    private static final int UPDATE_BACKOFF_TICKS = 1;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);
    private boolean shouldSendUpdate = false;
    private int sendUpdateBackoff = 0;
    private final boolean ticking;
    private Map<Pair<Capability<?>, Direction>, LazyOptional<?>> capabilities = Maps.newHashMap();

    public CyclopsTileEntity(TileEntityType<?> type) {
        super(type);
        this.sendUpdateBackoff = (int)Math.round(Math.random() * (double)this.getUpdateBackoffTicks());
        this.ticking = this instanceof ITickingTile;
    }

    protected boolean isTicking() {
        return this.ticking;
    }

    public final void sendUpdate() {
        if (!this.isTicking()) {
            throw new RuntimeException("If you want to update, you must implement ITickingTile. This is a mod error.");
        }
        this.shouldSendUpdate = true;
    }

    public final void sendImmediateUpdate() {
        this.sendUpdate();
        this.sendUpdateBackoff = 0;
    }

    private void updateTicking() {
        this.updateTileEntity();
        this.trySendActualUpdate();
    }

    protected void updateTileEntity() {
    }

    private void trySendActualUpdate() {
        --this.sendUpdateBackoff;
        if (this.sendUpdateBackoff <= 0) {
            this.sendUpdateBackoff = this.getUpdateBackoffTicks();
            if (this.shouldSendUpdate) {
                this.shouldSendUpdate = false;
                this.beforeSendUpdate();
                this.onSendUpdate();
                this.afterSendUpdate();
            }
        }
    }

    protected void onSendUpdate() {
        BlockHelpers.markForUpdate(this.func_145831_w(), this.func_174877_v());
    }

    protected void beforeSendUpdate() {
    }

    protected void afterSendUpdate() {
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.getNBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tag = packet.func_148857_g();
        this.read(tag);
        this.onUpdateReceived();
    }

    public void onUpdateReceived() {
    }

    protected int getUpdateBackoffTicks() {
        return 1;
    }

    public boolean canInteractWith(PlayerEntity entityPlayer) {
        return true;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        this.writeGeneratedFieldsToNBT(tag);
        return tag;
    }

    public CompoundNBT writeToItemStack(CompoundNBT tag) {
        return this.func_189515_b(tag);
    }

    public final void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.read(tag);
    }

    public void read(CompoundNBT tag) {
        this.readGeneratedFieldsFromNBT(tag);
        this.onLoad();
    }

    public void onLoad() {
        if (this.capabilities instanceof HashMap) {
            this.capabilities = ImmutableMap.copyOf(this.capabilities);
        }
    }

    public CompoundNBT getNBTTagCompound() {
        CompoundNBT tag = new CompoundNBT();
        tag = this.func_189515_b(tag);
        return tag;
    }

    public CompoundNBT func_189517_E_() {
        return this.getNBTTagCompound();
    }

    protected Direction transformFacingForRotation(Direction facing) {
        if (facing == null) {
            return null;
        }
        if (this.getRotation() == null) {
            return facing;
        }
        return DirectionHelpers.transformFacingForRotation(facing, this.getRotation());
    }

    public Direction getRotation() {
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (this.capabilities != null) {
            LazyOptional<?> value = this.capabilities.get(Pair.of(capability, (Object)this.transformFacingForRotation(facing)));
            if (value == null && facing != null) {
                value = this.capabilities.get(Pair.of(capability, null));
            }
            if (value != null) {
                return value.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<?> lazyOptional : this.capabilities.values()) {
            lazyOptional.invalidate();
        }
    }

    public <T> void addCapabilityInternal(Capability<T> capability, LazyOptional<T> value) {
        this.capabilities.put(Pair.of(capability, null), value);
    }

    public <T> void addCapabilitySided(Capability<T> capability, Direction facing, LazyOptional<T> value) {
        this.capabilities.put(Pair.of(capability, (Object)facing), value);
    }

    protected Map<Pair<Capability<?>, Direction>, LazyOptional<?>> getStoredCapabilities() {
        return this.capabilities;
    }

    @Override
    public void onDirty() {
        this.func_70296_d();
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundNBT tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundNBT tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }

    public static class TickingTileComponent
    implements ITickingTile {
        private final CyclopsTileEntity tile;

        public TickingTileComponent(CyclopsTileEntity tile) {
            this.tile = tile;
        }

        public void func_73660_a() {
            this.tile.updateTicking();
        }
    }

    public static interface ITickingTile
    extends ITickableTileEntity {
    }
}

