/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tracking;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.IModVersion;

@Deprecated
public class Versions {
    private static final List<Triple<ModBase, IModVersion, String>> versionMods = Lists.newLinkedList();
    private static volatile boolean checked = false;
    private static volatile boolean allDone = false;
    private static volatile boolean displayed = false;

    public static synchronized void registerMod(ModBase mod, IModVersion modVersion, String versionUrl) {
        versionMods.add((Triple<ModBase, IModVersion, String>)Triple.of((Object)mod, (Object)modVersion, (Object)versionUrl));
    }

    protected static synchronized List<Triple<ModBase, IModVersion, String>> getVersionMods() {
        return Lists.newArrayList(versionMods);
    }

    public static void checkAll() {
        if (!checked) {
            checked = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    List<Triple<ModBase, IModVersion, String>> versionMods = Versions.getVersionMods();
                    for (Triple<ModBase, IModVersion, String> triple : versionMods) {
                        try {
                            URL url = new URL((String)triple.getRight());
                            String data = IOUtils.toString((URL)url, (Charset)Charset.forName("UTF-8"));
                            String[] lines = data.split("\\r?\\n");
                            if (lines.length < 3) {
                                ((ModBase)triple.getLeft()).log(Level.WARN, "Retrieved invalid version data.");
                                continue;
                            }
                            String version = lines[0];
                            String info = lines[1];
                            String updateUrl = lines[2];
                            Versions.setVersionInfo((ModBase)triple.getLeft(), (IModVersion)triple.getMiddle(), version, info, updateUrl);
                            if (((IModVersion)triple.getMiddle()).needsUpdate()) {
                                ((ModBase)triple.getLeft()).log(Level.INFO, String.format("%s is outdated, version %s can be found at %s.", ((ModBase)triple.getLeft()).getModName(), version, updateUrl));
                                continue;
                            }
                            ((ModBase)triple.getLeft()).log(Level.INFO, String.format("%s is up-to-date!", ((ModBase)triple.getLeft()).getModName()));
                        }
                        catch (IOException e) {
                            ((ModBase)triple.getLeft()).log(Level.WARN, "Could not get version info: " + e.toString());
                            Versions.setVersionInfo((ModBase)triple.getLeft(), (IModVersion)triple.getMiddle(), null, null, null);
                        }
                    }
                    allDone = true;
                }
            }).start();
        }
    }

    public static void setVersionInfo(ModBase mod, IModVersion modVersion, String version, String info, String updateUrl) {
        modVersion.setVersionInfo(version, info, updateUrl);
        if (version != null && info != null && updateUrl != null) {
            Versions.setForgeVersionInfo(mod, modVersion, version, info, updateUrl);
        }
    }

    public static void setForgeVersionInfo(ModBase mod, IModVersion modVersion, String version, String info, String updateUrl) {
        try {
            Field resultsField = VersionChecker.class.getDeclaredField("results");
            resultsField.setAccessible(true);
            Map results = (Map)resultsField.get(null);
            Constructor constructor = VersionChecker.CheckResult.class.getDeclaredConstructor(VersionChecker.Status.class, ComparableVersion.class, Map.class, String.class);
            constructor.setAccessible(true);
            VersionChecker.Status status = modVersion.needsUpdate() ? VersionChecker.Status.OUTDATED : VersionChecker.Status.UP_TO_DATE;
            ComparableVersion comparableVersion = new ComparableVersion(version);
            VersionChecker.CheckResult checkResult = (VersionChecker.CheckResult)constructor.newInstance(status, comparableVersion, ImmutableMap.of((Object)comparableVersion, (Object)info), updateUrl);
            IModInfo modInfo = (IModInfo)ModList.get().getModFileById(mod.getModId()).getMods().get(0);
            results.put(modInfo, checkResult);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            mod.log(Level.ERROR, String.format("Failed to set Forge version information for %s-%s.", mod.getModName(), version));
            e.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public synchronized void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && allDone && !displayed) {
            List<Triple<ModBase, IModVersion, String>> versionMods = Versions.getVersionMods();
            for (Triple<ModBase, IModVersion, String> triple : versionMods) {
                if (!((IModVersion)triple.getMiddle()).needsUpdate()) continue;
                PlayerEntity player = event.player;
                StringTextComponent chat = new StringTextComponent("");
                Style modNameStyle = Style.field_240709_b_;
                modNameStyle.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.AQUA));
                Style versionStyle = Style.field_240709_b_;
                versionStyle.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.AQUA));
                Style downloadStyle = Style.field_240709_b_;
                downloadStyle.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.BLUE));
                String currentVersion = MinecraftHelpers.getMinecraftVersion() + "-" + ((ModBase)triple.getLeft()).getContainer().getModInfo().getVersion().toString();
                String newVersion = MinecraftHelpers.getMinecraftVersion() + "-" + ((IModVersion)triple.getMiddle()).getVersion();
                IFormattableTextComponent versionTransition = new StringTextComponent(String.format("%s -> %s", currentVersion, newVersion)).func_230530_a_(versionStyle);
                modNameStyle.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)versionTransition));
                IFormattableTextComponent modNameComponent = new StringTextComponent(String.format("[%s]", ((ModBase)triple.getLeft()).getModName())).func_230530_a_(modNameStyle);
                IFormattableTextComponent downloadComponent = new TranslationTextComponent(L10NHelpers.localize("general.cyclopscore.version.download", new Object[0])).func_230530_a_(downloadStyle);
                downloadStyle.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("general.cyclopscore.version.clickToDownload")));
                downloadStyle.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, ((IModVersion)triple.getMiddle()).getUpdateUrl()));
                chat.func_230529_a_((ITextComponent)modNameComponent);
                chat.func_240702_b_(" ");
                chat.func_230529_a_((ITextComponent)new TranslationTextComponent("general.cyclopscore.version.updateAvailable").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.WHITE))));
                chat.func_240702_b_(String.format(": %s ", ((IModVersion)triple.getMiddle()).getVersion()));
                chat.func_230529_a_((ITextComponent)downloadComponent);
                try {
                    player.func_145747_a((ITextComponent)chat, Util.field_240973_b_);
                    chat = new StringTextComponent("");
                    chat.func_230529_a_((ITextComponent)modNameComponent);
                    chat.func_240702_b_(TextFormatting.WHITE + " ");
                    chat.func_240702_b_(((IModVersion)triple.getMiddle()).getInfo());
                    player.func_145747_a((ITextComponent)chat, Util.field_240973_b_);
                }
                catch (NullPointerException e) {
                    return;
                }
            }
            displayed = true;
            try {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

