/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandler;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandlerRegistry;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandler;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandlerRegistry;
import org.cyclops.integratedtunnels.core.PlayerHelpers;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.item.ItemDummyPickAxe;

public class ItemStorageBlockWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private final boolean writeOnly;
    private final ServerWorld world;
    private final BlockPos pos;
    private final Direction side;
    private final Hand hand;
    private final boolean blockUpdate;
    private final int fortune;
    private final boolean silkTouch;
    private final boolean ignoreReplacable;
    private final boolean breakOnNoDrops;
    private IBlockBreakHandler blockBreakHandler = null;
    private List<ItemStack> cachedDrops = null;
    private boolean extracted = false;

    public ItemStorageBlockWrapper(boolean writeOnly, ServerWorld world, BlockPos pos, Direction side, Hand hand, boolean blockUpdate, int fortune, boolean silkTouch, boolean ignoreReplacable, boolean breakOnNoDrops) {
        this.writeOnly = writeOnly;
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.hand = hand;
        this.blockUpdate = blockUpdate;
        this.fortune = fortune;
        this.silkTouch = silkTouch;
        this.ignoreReplacable = ignoreReplacable;
        this.breakOnNoDrops = breakOnNoDrops;
    }

    protected void sendBlockUpdate() {
        this.world.func_190524_a(this.pos, Blocks.field_150350_a, this.pos);
    }

    protected IBlockBreakHandler getBlockBreakHandler(BlockState blockState, World world, BlockPos pos, PlayerEntity player) {
        return ((IBlockBreakHandlerRegistry)IntegratedTunnels._instance.getRegistryManager().getRegistry(IBlockBreakHandlerRegistry.class)).getHandler(blockState, world, pos, player);
    }

    protected void removeBlock(BlockState blockState, PlayerEntity player) {
        if (this.blockBreakHandler != null) {
            this.blockBreakHandler.breakBlock(blockState, (World)this.world, this.pos, player);
        } else {
            blockState.func_177230_c().removedByPlayer(blockState, (World)this.world, this.pos, player, false, this.world.func_204610_c(this.pos));
        }
        if (GeneralConfig.worldInteractionEvents) {
            this.world.func_217379_c(2001, this.pos, Block.func_196246_j((BlockState)blockState));
        }
        if (this.blockUpdate) {
            this.sendBlockUpdate();
        }
    }

    public static List<ItemStack> getDrops(BlockState state, ServerWorld worldIn, BlockPos pos, @Nullable TileEntity tileEntityIn) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder(worldIn).func_216023_a(worldIn.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileEntityIn);
        return state.func_215693_a(lootcontext$builder);
    }

    public boolean isExtracted() {
        return this.extracted;
    }

    @Nullable
    public List<ItemStack> getCachedDrops() {
        return this.cachedDrops;
    }

    protected List<ItemStack> getItemStacks() {
        if (this.writeOnly) {
            boolean isDestReplaceable;
            if (!(this.world.func_175623_d(this.pos) || (isDestReplaceable = this.world.func_180495_p(this.pos).func_196953_a(TunnelHelpers.createBlockItemUseContext((World)this.world, null, this.pos, this.side, this.hand))) && this.ignoreReplacable)) {
                BlockState blockState = this.world.func_180495_p(this.pos);
                return Lists.newArrayList((Object[])new ItemStack[]{BlockHelpers.getItemStackFromBlockState((BlockState)blockState)});
            }
        } else {
            if (this.cachedDrops != null) {
                return this.cachedDrops;
            }
            if (!this.world.func_175623_d(this.pos)) {
                BlockState blockState = this.world.func_180495_p(this.pos);
                FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
                PlayerHelpers.setPlayerState((PlayerEntity)player, this.hand, this.pos, 0.0, 0.0, 0.0, this.side, false);
                this.blockBreakHandler = this.getBlockBreakHandler(blockState, (World)this.world, this.pos, (PlayerEntity)player);
                if (this.blockBreakHandler != null) {
                    this.cachedDrops = this.blockBreakHandler.getDrops(blockState, (World)this.world, this.pos, (PlayerEntity)player);
                } else {
                    BlockEvent.BreakEvent blockBreakEvent = new BlockEvent.BreakEvent((World)this.world, this.pos, blockState, (PlayerEntity)player);
                    if (!MinecraftForge.EVENT_BUS.post((Event)blockBreakEvent)) {
                        List drops = Block.func_220077_a((BlockState)blockState, (ServerWorld)this.world, (BlockPos)this.pos, (TileEntity)this.world.func_175625_s(this.pos), null, (ItemStack)ItemDummyPickAxe.getItemStack(this.silkTouch, this.fortune));
                        if (drops.size() == 0) {
                            if (this.breakOnNoDrops) {
                                this.removeBlock(blockState, (PlayerEntity)player);
                            }
                            drops = Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
                        } else {
                            drops.removeIf(ItemStack::func_190926_b);
                        }
                        this.cachedDrops = drops;
                        return this.cachedDrops;
                    }
                }
            }
        }
        return Lists.newArrayList((Object[])new ItemStack[]{ItemStack.field_190927_a});
    }

    protected IBlockPlaceHandler getBlockPlaceHandler(ItemStack itemStack, World world, BlockPos pos, Direction side, float hitX, float hitY, float hitZ, PlayerEntity player) {
        return ((IBlockPlaceHandlerRegistry)IntegratedTunnels._instance.getRegistryManager().getRegistry(IBlockPlaceHandlerRegistry.class)).getHandler(itemStack, world, pos, side, hitX, hitY, hitZ, player);
    }

    protected ItemStack setItemStack(ItemStack itemStack, boolean simulate) {
        Item item;
        if (!itemStack.func_190926_b() && itemStack.func_190916_E() == 1 && (item = itemStack.func_77973_b()) instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
            PlayerHelpers.setPlayerState((PlayerEntity)player, this.hand, this.pos, 0.0, 0.0, 0.0, this.side, false);
            IBlockPlaceHandler blockPlaceHandler = this.getBlockPlaceHandler(itemStack, (World)this.world, this.pos, this.side.func_176734_d(), 0.0f, 0.0f, 0.0f, (PlayerEntity)player);
            if (blockPlaceHandler != null) {
                blockPlaceHandler.placeBlock(itemStack, (World)this.world, this.pos, this.side.func_176734_d(), 0.0f, 0.0f, 0.0f, (PlayerEntity)player);
            } else {
                BlockItemUseContext blockItemUseContext = TunnelHelpers.createBlockItemUseContext((World)this.world, (PlayerEntity)player, this.pos, this.side.func_176734_d(), this.hand);
                BlockState blockState = itemBlock.func_179223_d().func_196258_a(blockItemUseContext);
                if (blockState != null && (simulate || itemBlock.func_195941_b(blockItemUseContext, blockState))) {
                    if (!simulate) {
                        itemBlock.func_195943_a(this.pos, (World)this.world, blockItemUseContext.func_195999_j(), itemStack, blockState);
                        itemBlock.func_179223_d().func_180633_a((World)this.world, this.pos, blockState, (LivingEntity)player, itemStack);
                        if (GeneralConfig.worldInteractionEvents) {
                            SoundType soundtype = this.world.func_180495_p(this.pos).func_177230_c().getSoundType(this.world.func_180495_p(this.pos), (IWorldReader)this.world, this.pos, (Entity)player);
                            this.world.func_184133_a((PlayerEntity)player, this.pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                        }
                        if (this.blockUpdate) {
                            this.sendBlockUpdate();
                        }
                    }
                    return ItemStack.field_190927_a;
                }
            }
        }
        return itemStack;
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Lists.newArrayList(this.getItemStacks()).iterator();
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return new FilteredIngredientCollectionIterator((Iterable)((Object)this), this.getComponent().getMatcher(), (Object)prototype, (Object)matchCondition);
    }

    public long getMaxQuantity() {
        return 1L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.size() > 0 && !(itemStack = itemStacks.get(0)).func_190926_b()) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return stack;
        }
        ItemStack remaining = stack.func_77946_l();
        if (!this.setItemStack(remaining.func_77979_a(1), simulate).func_190926_b()) {
            return stack;
        }
        return remaining;
    }

    public void postExtract() {
        boolean allEmpty = true;
        for (ItemStack stack : this.getItemStacks()) {
            if (stack.func_190926_b()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            BlockState blockState = this.world.func_180495_p(this.pos);
            FakePlayer player = PlayerHelpers.getFakePlayer(this.world);
            player.func_184598_c(this.hand);
            this.removeBlock(blockState, (PlayerEntity)player);
        }
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Integer quantityFlag = (Integer)this.getComponent().getPrimaryQuantifier().getMatchCondition();
        Integer subMatchCondition = (Integer)matcher.withoutCondition((Object)matchCondition, (Object)quantityFlag);
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ListIterator<ItemStack> it = itemStacks.listIterator();
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (!matcher.matches((Object)prototype, (Object)itemStack, (Object)subMatchCondition) || matcher.hasCondition((Object)matchCondition, (Object)quantityFlag) && itemStack.func_190916_E() < prototype.func_190916_E()) continue;
            itemStack = itemStack.func_77946_l();
            ItemStack ret = itemStack.func_77979_a(Helpers.castSafe((long)prototype.func_190916_E()));
            if (!simulate) {
                if (itemStack.func_190926_b()) {
                    it.remove();
                } else {
                    it.set(itemStack);
                }
            }
            if (!simulate) {
                this.extracted = true;
                this.postExtract();
            }
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        List<ItemStack> itemStacks = this.getItemStacks();
        if (itemStacks.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = itemStacks.get(0);
        itemStack = itemStack.func_77946_l();
        ItemStack ret = itemStack.func_77979_a(Helpers.castSafe((long)maxQuantity));
        if (!simulate) {
            if (itemStack.func_190926_b()) {
                itemStacks.remove(0);
            } else {
                itemStacks.set(0, itemStack);
            }
        }
        if (!simulate) {
            this.extracted = true;
            this.postExtract();
        }
        return ret;
    }
}

