/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;
import org.cyclops.integratedtunnels.core.PlayerHelpers;

public class ItemStoragePlayerWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private static final Predicate<Entity> CAN_BE_ATTACKED = Entity::func_70075_an;
    private final ExtendedFakePlayer player;
    private final ServerWorld world;
    private final BlockPos pos;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final Direction side;
    private final Hand hand;
    private final boolean rightClick;
    private final boolean sneaking;
    private final boolean continuousClick;
    private final int entityIndex;
    private final IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler;

    public ItemStoragePlayerWrapper(@Nullable ExtendedFakePlayer player, ServerWorld world, BlockPos pos, double offsetX, double offsetY, double offsetZ, Direction side, Hand hand, boolean rightClick, boolean sneaking, boolean continuousClick, int entityIndex, IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler) {
        this.player = player;
        this.world = world;
        this.pos = pos;
        this.continuousClick = continuousClick;
        this.entityIndex = entityIndex;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.side = side;
        this.hand = hand;
        this.rightClick = rightClick;
        this.sneaking = sneaking;
        this.playerReturnHandler = playerReturnHandler;
    }

    public static void cancelDestroyingBlock(ServerPlayerEntity player) {
        player.field_71134_c.field_73088_d = false;
        player.field_71134_c.field_73094_o = -1;
    }

    protected Entity getEntity(List<Entity> entities) {
        if (this.entityIndex < 0) {
            return entities.get(this.world.field_73012_v.nextInt(entities.size()));
        }
        return entities.get(Math.min(this.entityIndex, entities.size() - 1));
    }

    private void returnPlayerInventory(PlayerEntity player) {
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack.func_190926_b()) continue;
            ItemStack remaining = (ItemStack)this.playerReturnHandler.insert((Object)itemStack, false);
            ItemStackHelpers.spawnItemStackToPlayer((World)this.world, (BlockPos)this.pos, (ItemStack)remaining, (PlayerEntity)player);
            it.remove();
        }
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])new ItemStack[0]);
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return this.iterator();
    }

    public long getMaxQuantity() {
        return 1L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        if (simulate) {
            return ItemStack.field_190927_a;
        }
        if (this.player == null) {
            return stack;
        }
        PlayerHelpers.setPlayerState((PlayerEntity)this.player, this.hand, this.pos, this.offsetX, this.offsetY, this.offsetZ, this.side, this.sneaking);
        PlayerHelpers.setHeldItemSilent((PlayerEntity)this.player, this.hand, stack);
        if (!this.continuousClick) {
            ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayerEntity)this.player);
        }
        if (this.rightClick) {
            List entities;
            boolean flag1;
            BlockRayTraceResult blockRayTraceResult = new BlockRayTraceResult(new Vector3d(this.offsetX, this.offsetY, this.offsetZ), this.side, this.pos, false);
            PlayerInteractEvent.RightClickBlock rightClickBlockActionResult = ForgeHooks.onRightClickBlock((PlayerEntity)this.player, (Hand)this.hand, (BlockPos)this.pos, (BlockRayTraceResult)blockRayTraceResult);
            if (rightClickBlockActionResult.isCanceled()) {
                return stack;
            }
            if (rightClickBlockActionResult.getUseItem() != Event.Result.DENY && !stack.func_190926_b()) {
                ItemUseContext itemUseContext = new ItemUseContext((PlayerEntity)this.player, this.hand, blockRayTraceResult);
                ActionResultType actionResult = stack.func_77973_b().onItemUseFirst(stack, itemUseContext);
                if (actionResult == ActionResultType.FAIL) {
                    return stack;
                }
                if (actionResult.func_226246_a_()) {
                    this.returnPlayerInventory((PlayerEntity)this.player);
                    return ItemStack.field_190927_a;
                }
            }
            boolean playerHasHeldItem = !this.player.func_184614_ca().func_190926_b() || !this.player.func_184592_cb().func_190926_b();
            boolean bl = flag1 = this.player.func_226563_dT_() && playerHasHeldItem && (!this.player.func_184614_ca().doesSneakBypassUse((IWorldReader)this.world, this.pos, (PlayerEntity)this.player) || !this.player.func_184592_cb().doesSneakBypassUse((IWorldReader)this.world, this.pos, (PlayerEntity)this.player));
            if (rightClickBlockActionResult.getUseBlock() == Event.Result.ALLOW || rightClickBlockActionResult.getUseBlock() != Event.Result.DENY && !flag1) {
                BlockState blockState = this.world.func_180495_p(this.pos);
                if ((!this.player.func_213453_ef() || stack.func_190926_b()) && blockState.func_227031_a_((World)this.world, (PlayerEntity)this.player, this.hand, blockRayTraceResult).func_226246_a_()) {
                    this.returnPlayerInventory((PlayerEntity)this.player);
                    return ItemStack.field_190927_a;
                }
            }
            if ((entities = this.world.func_217357_a(Entity.class, new AxisAlignedBB(this.pos))).size() > 0) {
                Entity entity = this.getEntity(entities);
                ActionResultType actionResult = this.player.func_190775_a(entity, this.hand);
                if (actionResult == ActionResultType.FAIL) {
                    return stack;
                }
                if (actionResult.func_226246_a_()) {
                    this.returnPlayerInventory((PlayerEntity)this.player);
                    return ItemStack.field_190927_a;
                }
            }
            if (rightClickBlockActionResult.getUseItem() != Event.Result.DENY && !stack.func_190926_b()) {
                ActionResultType cancelResult = ForgeHooks.onItemRightClick((PlayerEntity)this.player, (Hand)this.hand);
                if (cancelResult != null) {
                    if (cancelResult == ActionResultType.FAIL) {
                        return stack;
                    }
                    if (cancelResult.func_226246_a_()) {
                        this.returnPlayerInventory((PlayerEntity)this.player);
                        return ItemStack.field_190927_a;
                    }
                } else {
                    ItemStack copyBeforeUse = stack.func_77946_l();
                    ActionResult actionresult = stack.func_77957_a((World)this.world, (PlayerEntity)this.player, this.hand);
                    if (actionresult.func_188397_a() == ActionResultType.FAIL) {
                        return stack;
                    }
                    if (((ItemStack)actionresult.func_188398_b()).func_190926_b()) {
                        PlayerHelpers.setHeldItemSilent((PlayerEntity)this.player, this.hand, ItemStack.field_190927_a);
                        ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this.player, (ItemStack)copyBeforeUse, (Hand)this.hand);
                    } else {
                        PlayerHelpers.setHeldItemSilent((PlayerEntity)this.player, this.hand, (ItemStack)actionresult.func_188398_b());
                    }
                    if (actionresult.func_188397_a().func_226246_a_()) {
                        if (this.player.func_184587_cr()) {
                            this.player.updateActiveHandSimulated();
                            this.player.func_184597_cx();
                        }
                        this.returnPlayerInventory((PlayerEntity)this.player);
                        return ItemStack.field_190927_a;
                    }
                }
            }
            if (rightClickBlockActionResult.getUseItem() != Event.Result.DENY && !stack.func_190926_b()) {
                BlockPos targetPos = this.pos;
                double reachDistance = this.player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 3.0;
                int i = 0;
                while (true) {
                    int n = i++;
                    if (!((double)n < reachDistance) || !this.world.func_175623_d(targetPos)) break;
                    targetPos = targetPos.func_177972_a(this.side.func_176734_d());
                }
                ItemUseContext itemUseContextReach = new ItemUseContext((PlayerEntity)this.player, this.hand, new BlockRayTraceResult(new Vector3d(this.offsetX, this.offsetY, this.offsetZ), this.side, targetPos, false));
                ActionResultType actionResult = stack.func_196084_a(itemUseContextReach);
                if (actionResult == ActionResultType.FAIL) {
                    return stack;
                }
                if (actionResult.func_226246_a_()) {
                    this.returnPlayerInventory((PlayerEntity)this.player);
                    return ItemStack.field_190927_a;
                }
            }
        } else {
            PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock((PlayerEntity)this.player, (BlockPos)this.pos, (Direction)this.side);
            BlockState blockState = this.world.func_180495_p(this.pos);
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                this.world.func_184138_a(this.pos, blockState, this.world.func_180495_p(this.pos), 3);
                return stack;
            }
            if (!this.world.func_175623_d(this.pos)) {
                int durabilityRemaining = this.player.field_71134_c.field_73094_o;
                if (durabilityRemaining < 0) {
                    this.world.func_180495_p(this.pos).func_196942_a((World)this.world, this.pos, (PlayerEntity)this.player);
                    float relativeBlockHardness = blockState.func_185903_a((PlayerEntity)this.player, (IBlockReader)this.player.field_70170_p, this.pos);
                    if (relativeBlockHardness >= 1.0f) {
                        this.player.field_71134_c.func_180237_b(this.pos);
                    } else {
                        this.player.field_71134_c.field_73089_e = this.player.field_71134_c.field_73100_i;
                        this.player.field_71134_c.field_73088_d = true;
                        this.player.field_71134_c.field_180240_f = this.pos.func_185334_h();
                        this.player.field_71134_c.field_73094_o = (int)(relativeBlockHardness * 10.0f);
                    }
                } else if (durabilityRemaining >= 9) {
                    this.player.field_71134_c.func_180237_b(this.pos);
                    ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayerEntity)this.player);
                } else {
                    this.player.field_71134_c.func_73075_a();
                }
                this.returnPlayerInventory((PlayerEntity)this.player);
                return ItemStack.field_190927_a;
            }
            ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayerEntity)this.player);
            List entities = this.world.func_175647_a(Entity.class, new AxisAlignedBB(this.pos), CAN_BE_ATTACKED::test);
            if (entities.size() > 0) {
                Entity entity = this.getEntity(entities);
                EquipmentSlotType equipmentSlotType = this.hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
                this.player.func_233645_dx_().func_233793_b_(stack.func_111283_C(equipmentSlotType));
                this.player.func_71059_n(entity);
                this.player.func_233645_dx_().func_233785_a_(stack.func_111283_C(equipmentSlotType));
                this.returnPlayerInventory((PlayerEntity)this.player);
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        return stack;
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        return ItemStack.field_190927_a;
    }
}

