/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypesAndSizeContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class EntityDragonfly
extends EntityAnimalWithTypesAndSizeContainable {
    private static final DataParameter<Integer> LANDED = EntityDataManager.func_187226_a(EntityDragonfly.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final EntityPredicate playerPredicate = new EntityPredicate().func_221013_a(4.0).func_221011_b().func_221008_a();
    private BlockPos targetPosition;
    private int rainTicks = 0;

    public EntityDragonfly(EntityType<? extends EntityDragonfly> entityType, World worldIn) {
        super((EntityType<? extends EntityAnimalWithTypesAndSizeContainable>)entityType, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(LANDED, (Object)1);
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || source == DamageSource.field_220302_v;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public boolean isLanded() {
        return (Integer)this.field_70180_af.func_187225_a(LANDED) != 1;
    }

    public int getLandedInteger() {
        return (Integer)this.field_70180_af.func_187225_a(LANDED);
    }

    public void setLanded(Direction direction) {
        if (direction == Direction.UP) {
            throw new RuntimeException("Invalid landing direction!");
        }
        this.field_70180_af.func_187227_b(LANDED, (Object)direction.ordinal());
    }

    public void setNotLanded() {
        this.field_70180_af.func_187227_b(LANDED, (Object)1);
        this.func_70634_a((double)this.func_233580_cy_().func_177958_n() + 0.5, (double)this.func_233580_cy_().func_177956_o() + 0.5, (double)this.func_233580_cy_().func_177952_p() + 0.5);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isLanded()) {
            this.func_213317_d(Vector3d.field_186680_a);
            if (Direction.func_82600_a((int)this.getLandedInteger()) != Direction.DOWN) {
                double x = Math.floor(this.func_226277_ct_()) + 0.5;
                double z = Math.floor(this.func_226281_cx_()) + 0.5;
                BlockPos pos = new BlockPos(x, Math.floor(this.func_226278_cu_()) + 0.5, z);
                BlockPos offset = pos.func_177972_a(Direction.func_82600_a((int)this.getLandedInteger()));
                BlockPos diff = pos.func_177973_b((Vector3i)offset);
                this.func_70634_a(x - (double)diff.func_177958_n() / 2.778, Math.floor(this.func_226278_cu_()) + 0.5, z - (double)diff.func_177952_p() / 2.778);
                this.field_70177_z = 0.0f;
                this.field_70759_as = 0.0f;
            } else {
                this.func_70634_a(this.func_226277_ct_(), Math.floor(this.func_226278_cu_()), this.func_226281_cx_());
            }
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
    }

    public boolean isRainingAt(BlockPos position) {
        if (!this.field_70170_p.func_72896_J()) {
            return false;
        }
        if (position == null) {
            return true;
        }
        if (!this.field_70170_p.func_195588_v(position) || !this.field_70170_p.func_175710_j(position)) {
            return false;
        }
        return this.field_70170_p.func_226691_t_(position).func_201851_b() == Biome.RainType.RAIN;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = this.func_233580_cy_();
        if (this.isLanded()) {
            Direction direction = Direction.func_82600_a((int)this.getLandedInteger());
            Direction[] offset = blockpos.func_177972_a(direction);
            if (this.field_70170_p.func_180495_p((BlockPos)offset).func_242698_a((IBlockReader)this.field_70170_p, (BlockPos)offset, direction.func_176734_d(), BlockVoxelShape.CENTER)) {
                if (this.field_70170_p.func_217370_a(playerPredicate, (LivingEntity)this) != null || this.func_70681_au().nextInt(500) == 0) {
                    this.setNotLanded();
                }
            } else {
                this.setNotLanded();
            }
        }
        if (this.isRainingAt(this.func_233580_cy_())) {
            ++this.rainTicks;
            if (this.isLanded()) {
                this.setNotLanded();
            }
            if (this.targetPosition == null || this.isRainingAt(this.targetPosition)) {
                this.targetPosition = this.tryToFindPositionBlock(pos -> {
                    if (pos != null && !this.isRainingAt((BlockPos)pos) && this.field_70170_p.func_175623_d(pos)) {
                        for (Direction direction : Direction.values()) {
                            BlockPos offset;
                            if (direction == Direction.UP || !this.field_70170_p.func_180495_p(offset = pos.func_177972_a(direction)).func_242698_a((IBlockReader)this.field_70170_p, offset, direction.func_176734_d(), BlockVoxelShape.CENTER)) continue;
                            return true;
                        }
                        return false;
                    }
                    return false;
                });
            }
            if (this.func_70681_au().nextFloat() < 0.0025f && this.rainTicks > 100) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        } else {
            this.rainTicks = 0;
            if (this.targetPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.targetPosition.func_218137_a((IPosition)this.func_213303_ch(), 1.0)) {
                if (this.field_70170_p.func_72896_J() && this.field_70170_p.func_226691_t_(this.func_233580_cy_()).func_201851_b() == Biome.RainType.RAIN) {
                    BlockPos temp;
                    boolean found = false;
                    for (Direction direction : Direction.values()) {
                        BlockPos offset;
                        if (direction == Direction.UP || !this.field_70170_p.func_180495_p(offset = blockpos.func_177972_a(direction)).func_242698_a((IBlockReader)this.field_70170_p, offset, direction.func_176734_d(), BlockVoxelShape.CENTER) || !this.field_70170_p.func_175623_d(blockpos)) continue;
                        this.setLanded(direction);
                        this.targetPosition = null;
                        found = true;
                        break;
                    }
                    if (!found && !this.isRainingAt(temp = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(4) - 1.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5)))) {
                        this.targetPosition = temp;
                    }
                } else {
                    boolean found = false;
                    if (this.field_70170_p.func_217370_a(playerPredicate, (LivingEntity)this) == null) {
                        for (Direction direction : Direction.values()) {
                            BlockPos offset;
                            if (direction == Direction.UP || !this.field_70170_p.func_180495_p(offset = blockpos.func_177972_a(direction)).func_242698_a((IBlockReader)this.field_70170_p, offset, direction.func_176734_d(), BlockVoxelShape.CENTER) || !this.field_70170_p.func_175623_d(blockpos)) continue;
                            this.setLanded(direction);
                            this.targetPosition = null;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        for (int attempts = 0; !(attempts >= 5 || this.targetPosition != null && this.field_70170_p.func_175623_d(this.targetPosition)); ++attempts) {
                            this.targetPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(4) - 1.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(5) - (double)this.field_70146_Z.nextInt(5));
                        }
                    }
                }
            }
            if (this.targetPosition != null && this.targetPosition.func_218137_a((IPosition)this.func_213303_ch(), 1.0)) {
                this.targetPosition = null;
            }
        }
        if (!this.isLanded() && this.targetPosition != null) {
            if (this.func_70094_T()) {
                this.targetPosition = this.tryToFindPositionSlow(pos -> {
                    AxisAlignedBB abb = this.func_174813_aQ();
                    Vector3d diff = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5).func_178788_d(this.func_213303_ch());
                    double length = diff.func_72433_c();
                    diff = diff.func_72432_b();
                    int i = 1;
                    while ((double)i < length) {
                        if (!this.field_70170_p.func_226665_a__((Entity)this, abb = abb.func_191194_a(diff))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                });
            }
            double d0 = (double)this.targetPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d1 = (double)this.targetPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d2 = (double)this.targetPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            Vector3d vec3d = this.func_213322_ci();
            Vector3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
        }
    }

    private BlockPos tryToFindPositionBlock(Predicate<BlockPos> condition) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int i = 12;
        int j = 2;
        int k = 0;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        pos.func_189533_g((Vector3i)this.func_233580_cy_()).func_196234_d(i1, k - 1, j1);
                        if (condition.test(pos.func_185334_h())) {
                            return pos.func_185334_h();
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return null;
    }

    private BlockPos tryToFindPositionSlow(Predicate<BlockPos> condition) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        int i = 12;
        int j = 2;
        boolean down = false;
        while (!down) {
            int k;
            int n = k = down ? -1 : 0;
            while (down ? k >= -j : k <= j) {
                for (int l = 0; l < i; ++l) {
                    int i1 = 0;
                    while (i1 <= l) {
                        int j1;
                        int n2 = j1 = i1 < l && i1 > -l ? l : 0;
                        while (j1 <= l) {
                            pos.func_189533_g((Vector3i)this.func_233580_cy_()).func_196234_d(i1, k, j1);
                            if (condition.test(pos.func_185334_h())) {
                                return pos.func_185334_h();
                            }
                            j1 = j1 > 0 ? -j1 : 1 - j1;
                        }
                        i1 = i1 > 0 ? -i1 : 1 - i1;
                    }
                }
                k += down ? -1 : 1;
            }
            down = true;
        }
        return null;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isLanded()) {
            this.setNotLanded();
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(LANDED, (Object)compound.func_74762_e("Landed"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Landed", ((Integer)this.field_70180_af.func_187225_a(LANDED)).intValue());
    }

    @Override
    protected float getRandomizedSize() {
        return ((float)this.field_70146_Z.nextInt(30) + 1.0f) / 100.0f + 0.15f;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    @Override
    public EntityTypeContainer<? extends EntityDragonfly> getContainer() {
        return ModEntities.DRAGONFLY;
    }

    @Override
    protected EntityAnimalWithTypes getBaseChild() {
        return null;
    }

    public EntityTypeContainerContainable<? extends EntityDragonfly, ?> getContainableContainer() {
        return ModEntities.DRAGONFLY;
    }

    @Override
    public void setContainerData(ItemStack bucket) {
        super.setContainerData(bucket);
        CompoundNBT tag = bucket.func_77978_p();
        tag.func_74776_a("SizeTag", ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue());
        bucket.func_77982_d(tag);
    }

    @Override
    public void readFromContainerTag(CompoundNBT tag) {
        super.readFromContainerTag(tag);
        if (tag.func_74764_b("SizeTag")) {
            this.setSize(tag.func_74760_g("SizeTag"));
        }
    }

    public static void bottleTooltip(EntityTypeContainer<? extends MobEntity> container, ItemStack stack, World worldIn, List<ITextComponent> tooltip) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("SizeTag", 5)) {
            tooltip.add((ITextComponent)new StringTextComponent("Size: " + tag.func_74760_g("SizeTag")).func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

