/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobWithTypesBucketable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityJellyfish
extends EntityWaterMobWithTypesBucketable {
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityJellyfish.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected int attackCooldown = 0;
    public float jellyYaw;
    public float prevJellyYaw;
    public float jellyRotation;
    public float prevJellyRotation;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityJellyfish(EntityType<? extends EntityJellyfish> entityType, World worldIn) {
        super((EntityType<? extends EntityWaterMobWithTypesBucketable>)entityType, worldIn);
        this.setSize(0.8f);
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new AIMoveRandom(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevJellyYaw = this.jellyYaw;
        this.prevJellyRotation = this.jellyRotation;
        this.jellyRotation += this.rotationVelocity;
        if ((double)this.jellyRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.jellyRotation = (float)Math.PI * 2;
            } else {
                this.jellyRotation = (float)((double)this.jellyRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.jellyRotation < (float)Math.PI) {
                float lvt_1_1_ = this.jellyRotation / (float)Math.PI;
                if ((double)lvt_1_1_ > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.randomMotionVecX * this.randomMotionSpeed, this.randomMotionVecY * this.randomMotionSpeed, this.randomMotionVecZ * this.randomMotionSpeed);
            }
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)this.func_213322_ci().func_82615_a(), (double)this.func_213322_ci().func_82616_c())) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.jellyYaw = (float)((double)this.jellyYaw + Math.PI * (double)this.rotateSpeed * 1.5);
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_213293_j(0.0, this.func_213322_ci().func_82617_b(), 0.0);
            if (this.func_70644_a(Effects.field_188424_y)) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b() + 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
            } else if (!this.func_189652_ae()) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b() - 0.08, this.func_213322_ci().func_82616_c());
            }
            this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b() * (double)0.98f, this.func_213322_ci().func_82616_c());
        }
    }

    public void func_70100_b_(PlayerEntity entity) {
        super.func_70100_b_(entity);
        if (!entity.func_184812_l_() && this.attackCooldown == 0 && entity.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
            entity.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 0, false, false));
            entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 90, 2, false, false));
            this.attackCooldown = 80;
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187886_fs;
    }

    public void func_213352_e(Vector3d vec) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 19) {
            this.jellyRotation = 0.0f;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public void setMovementVector(float p_175568_1_, float p_175568_2_, float p_175568_3_) {
        this.randomMotionVecX = p_175568_1_;
        this.randomMotionVecY = p_175568_2_;
        this.randomMotionVecZ = p_175568_3_;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    public EntitySize func_213305_a(Pose pose) {
        float size = ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
        return EntitySize.func_220314_b((float)size, (float)size).func_220313_a(this.func_213355_cm());
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Size", this.func_213305_a((Pose)Pose.STANDING).field_220315_a);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        float size = compound.func_74760_g("Size");
        this.setSize(size);
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, ILivingEntityData livingdata, CompoundNBT compound) {
        livingdata = super.func_213386_a(world, difficulty, reason, livingdata, compound);
        if (!this.func_70631_g_()) {
            String i = this.getRandomType().getName();
            float rand = ((float)this.field_70146_Z.nextInt(30) + 1.0f) / 50.0f + 0.05f;
            if (livingdata instanceof JellyfishData) {
                i = ((JellyfishData)livingdata).typeData;
                rand = ((JellyfishData)livingdata).size;
            } else {
                livingdata = new JellyfishData(i, rand);
            }
            this.setType(i);
            this.setSize(rand);
        }
        return livingdata;
    }

    @Override
    public EntityJellyfish getImplementation() {
        return this;
    }

    @Override
    public EntityTypeContainer<EntityJellyfish> getContainer() {
        return ModEntities.JELLYFISH;
    }

    @Override
    public void setContainerData(ItemStack bucket) {
        super.setContainerData(bucket);
        CompoundNBT tag = bucket.func_77978_p();
        tag.func_74776_a("JellyfishSizeTag", ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue());
        bucket.func_77982_d(tag);
    }

    @Override
    public void readFromContainerTag(CompoundNBT tag) {
        super.readFromContainerTag(tag);
        if (tag.func_74764_b("JellyfishSizeTag")) {
            this.setSize(tag.func_74760_g("JellyfishSizeTag"));
        }
    }

    public static void bucketTooltip(EntityTypeContainer<? extends MobEntity> container, ItemStack stack, World worldIn, List<ITextComponent> tooltip) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("JellyfishSizeTag", 5)) {
            tooltip.add((ITextComponent)new StringTextComponent("Size: " + tag.func_74760_g("JellyfishSizeTag")).func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public EntityTypeContainerContainable<?, ?> getContainableContainer() {
        return ModEntities.JELLYFISH;
    }

    static class AIMoveRandom
    extends Goal {
        private final EntityJellyfish entity;

        public AIMoveRandom(EntityJellyfish entityIn) {
            this.entity = entityIn;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.entity.func_70654_ax();
            if (i > 100) {
                this.entity.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.entity.func_70681_au().nextInt(50) == 0 || !this.entity.field_70171_ac || !this.entity.hasMovementVector()) {
                float f = this.entity.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.entity.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.entity.setMovementVector(f1 / 3.0f, f2 / 3.0f, f3 / 3.0f);
            }
        }
    }

    public static class JellyfishData
    implements ILivingEntityData {
        public String typeData;
        public float size;

        public JellyfishData(String type, float size) {
            this.typeData = type;
            this.size = size;
        }
    }
}

