/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathing;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityWaterMobPathingWithTypesAirBreathing;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.ISelectiveVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.Set;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class EntityWhale
extends EntityWaterMobPathingWithTypesAirBreathing
implements ISelectiveVariantTypes<EntityWaterMobPathing> {
    public int attacksLeft = 0;

    public EntityWhale(EntityType<? extends EntityWhale> entityType, World worldIn) {
        super((EntityType<? extends EntityWaterMobPathingWithTypesAirBreathing>)entityType, worldIn);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WhaleMeleeAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]){

            public boolean func_75250_a() {
                return EntityWhale.this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && super.func_75250_a();
            }
        });
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_205212_bc;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_205211_bb;
    }

    private boolean isNarwhal() {
        return "narwhal".equals(this.getVariantNameOrEmpty());
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)(this.isNarwhal() ? this.func_110148_a(Attributes.field_233823_f_).func_111126_e() : 1.0));
        if (flag) {
            if (!this.isNarwhal()) {
                if (this.attacksLeft > 0) {
                    --this.attacksLeft;
                }
                if (entityIn instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entityIn;
                    int ticks = 0;
                    if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                        ticks = 50;
                    } else if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                        ticks = 100;
                    } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                        ticks = 140;
                    }
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, ticks, 1, false, false));
                    player.func_195064_c(new EffectInstance(Effects.field_76431_k, ticks + 40, 1, false, false));
                }
            }
            Vector3d pos = this.func_213303_ch();
            Vector3d targetPos = entityIn.func_213303_ch();
            ((LivingEntity)entityIn).func_233627_a_(this.isNarwhal() ? 0.8f : 2.0f, pos.field_72450_a - targetPos.field_72450_a, pos.field_72449_c - targetPos.field_72449_c);
        }
        return flag;
    }

    @Override
    public String[] getTypesFor(RegistryKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, SpawnReason reason) {
        if (biomeKey == Biomes.field_203616_V || biomeKey == Biomes.field_203619_Y) {
            return new String[]{"bottlenose", "pilot"};
        }
        if (biomeKey == Biomes.field_203620_Z || biomeKey == Biomes.field_76776_l) {
            return new String[]{"narwhal", "beluga"};
        }
        if (biomeKey == Biomes.field_203618_X || biomeKey == Biomes.field_150575_M || biomeKey == Biomes.field_203617_W) {
            return new String[]{"cuviers", "pilot"};
        }
        return new String[]{"cuviers", "pilot", "false_killer"};
    }

    @Override
    public EntityTypeContainer<? extends EntityWhale> getContainer() {
        return ModEntities.WHALE;
    }

    public static class WhaleMeleeAttackGoal
    extends MeleeAttackGoal {
        private final EntityWhale whale;

        public WhaleMeleeAttackGoal(EntityWhale whale) {
            super((CreatureEntity)whale, (double)1.2f, true);
            this.whale = whale;
        }

        public void func_75249_e() {
            if (!this.whale.isNarwhal()) {
                this.whale.attacksLeft = 1;
            }
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return (this.whale.isNarwhal() || this.whale.attacksLeft > 0) && super.func_75253_b();
        }

        protected void func_190102_a(LivingEntity p_190102_1_, double p_190102_2_) {
            if (this.whale.attacksLeft > 0 || this.whale.isNarwhal()) {
                super.func_190102_a(p_190102_1_, p_190102_2_);
            } else {
                this.func_75251_c();
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            if (this.whale.attacksLeft <= 0 && !this.whale.isNarwhal()) {
                this.field_75441_b.func_70624_b(null);
            }
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return this.field_75441_b.func_213311_cf() * this.field_75441_b.func_213311_cf() + attackTarget.func_213311_cf();
        }
    }
}

