/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.gui;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.network.ChunkLoaderCPH;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.lib.texture.TextureUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiChunkLoader
extends Screen {
    public Button laserButton;
    public Button shapeButton;
    public TileChunkLoader tile;
    private int lastRadius = -1;
    @Nullable
    private ChunkLoaderShape lastShape = null;
    private int lastButton;
    private long warningEnd = -1L;
    @Nullable
    private ITextComponent warningText;

    public GuiChunkLoader(TileChunkLoader tile) {
        super((ITextComponent)new StringTextComponent("DOOOOOOOT"));
        this.tile = tile;
    }

    public void func_231160_c_() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 20, this.field_230709_l_ / 2 - 45, 20, 20, (ITextComponent)new StringTextComponent("+"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius + 1)));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 80, this.field_230709_l_ / 2 - 45, 20, 20, (ITextComponent)new StringTextComponent("-"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius - 1)));
        this.laserButton = new Button(this.field_230708_k_ / 2 + 7, this.field_230709_l_ / 2 - 60, 75, 20, (ITextComponent)new StringTextComponent("-"), e -> {
            this.tile.renderInfo.showLasers = !this.tile.renderInfo.showLasers;
        });
        this.func_230480_a_((Widget)this.laserButton);
        this.shapeButton = new Button(this.field_230708_k_ / 2 + 7, this.field_230709_l_ / 2 - 37, 75, 20, (ITextComponent)new StringTextComponent("-"), e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.lastButton == 1 ? this.tile.shape.prev() : this.tile.shape.next(), this.tile.radius));
        this.func_230480_a_((Widget)this.shapeButton);
        this.updateNames();
        super.func_231160_c_();
    }

    public void updateNames() {
        this.laserButton.func_238482_a_((ITextComponent)new TranslationTextComponent(this.tile.renderInfo.showLasers ? "chickenchunks.gui.hidelasers" : "chickenchunks.gui.showlasers"));
        this.shapeButton.func_238482_a_(this.tile.shape.getTranslation());
        if (this.lastRadius != this.tile.radius || this.lastShape != this.tile.shape) {
            this.warningEnd = -1L;
            this.warningText = null;
            this.lastRadius = this.tile.radius;
            this.lastShape = this.tile.shape;
        }
    }

    public void addWarning(ITextComponent text) {
        this.warningText = text;
        this.warningEnd = System.currentTimeMillis() + 3500L;
    }

    public void func_231023_e_() {
        if (this.field_230706_i_.field_71441_e.func_175625_s(this.tile.func_174877_v()) != this.tile) {
            this.field_230706_i_.field_71462_r = null;
            this.field_230706_i_.field_71417_B.func_198034_i();
        }
        this.updateNames();
        super.func_231023_e_();
    }

    public void func_230430_a_(MatrixStack mStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.func_230446_a_(mStack);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureUtils.changeTexture((String)"chickenchunks:textures/gui/gui_small.png");
        int posx = this.field_230708_k_ / 2 - 88;
        int posy = this.field_230709_l_ / 2 - 83;
        this.func_238474_b_(mStack, posx, posy, 0, 0, 176, 166);
        super.func_230430_a_(mStack, p_render_1_, p_render_2_, p_render_3_);
        GlStateManager.func_227722_g_();
        GlStateManager.func_227731_j_();
        this.drawCentered(mStack, (ITextComponent)new TranslationTextComponent("chickenchunks.gui.name"), this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 - 74, 0x303030);
        if (this.tile.owner != null) {
            this.drawCentered(mStack, this.tile.ownerName, this.field_230708_k_ / 2 + 44, this.field_230709_l_ / 2 - 72, 0x801080);
        }
        this.drawCentered(mStack, (ITextComponent)new TranslationTextComponent("chickenchunks.gui.radius"), this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 - 57, 0x404040);
        this.drawCentered(mStack, (ITextComponent)new StringTextComponent("" + this.tile.radius), this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 - 39, 0xFFFFFF);
        int chunks = this.tile.countLoadedChunks();
        this.drawCentered(mStack, (ITextComponent)new TranslationTextComponent(chunks == 1 ? "chickenchunks.gui.chunk" : "chickenchunks.gui.chunks", new Object[]{chunks}), this.field_230708_k_ / 2 - 39, this.field_230709_l_ / 2 - 21, 0x108000);
        if (this.warningText != null && this.warningEnd != -1L) {
            float fade = (float)(this.warningEnd - System.currentTimeMillis()) / 1000.0f;
            if ((double)fade <= 0.1) {
                this.warningEnd = -1L;
                this.warningText = null;
            } else {
                int alpha = fade <= 1.0f ? (int)(255.0f * fade) : 255;
                this.drawCentered(mStack, this.warningText, this.field_230708_k_ / 2, this.field_230709_l_ / 2 - 8, 0xFF5555 | (alpha & 0xFF) << 24);
            }
        }
        GlStateManager.func_227716_f_();
        GlStateManager.func_227734_k_();
    }

    private void drawCentered(MatrixStack mStack, ITextComponent s, int x, int y, int colour) {
        this.field_230712_o_.func_238422_b_(mStack, s.func_241878_f(), (float)x - (float)this.field_230712_o_.func_238414_a_((ITextProperties)s) / 2.0f, (float)y, colour);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        this.lastButton = button;
        if (button == 1) {
            button = 0;
        }
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231177_au__() {
        return false;
    }
}

