/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.inventory.WrapperSlot;

public class MultiModuleContainer<TILE extends TileEntity>
extends BaseContainer<TILE> {
    public List<Container> subContainers = Lists.newArrayList();
    protected Map<Integer, Container> slotContainerMap = Maps.newHashMap();
    protected Map<Container, Pair<Integer, Integer>> subContainerSlotRanges = Maps.newHashMap();
    protected int subContainerSlotStart = -1;
    protected Set<Container> shiftClickContainers = Sets.newHashSet();

    public MultiModuleContainer(ContainerType<?> containerType, int id, @Nullable PlayerInventory inv, @Nullable TILE tile) {
        super(containerType, id, inv, tile);
    }

    public void addSubContainer(Container subcontainer, boolean preferForShiftClick) {
        if (this.subContainers.isEmpty()) {
            this.subContainerSlotStart = this.field_75151_b.size();
        }
        this.subContainers.add(subcontainer);
        if (preferForShiftClick) {
            this.shiftClickContainers.add(subcontainer);
        }
        int begin = this.field_75151_b.size();
        for (Object slot : subcontainer.field_75151_b) {
            WrapperSlot wrapper = new WrapperSlot((Slot)slot);
            this.func_75146_a(wrapper);
            this.slotContainerMap.put(wrapper.field_75222_d, subcontainer);
        }
        int end = this.field_75151_b.size();
        this.subContainerSlotRanges.put(subcontainer, (Pair<Integer, Integer>)Pair.of((Object)begin, (Object)end));
    }

    @Nullable
    public <CONTAINER extends Container> CONTAINER getSubContainer(Class<CONTAINER> clazz) {
        return this.getSubContainer(clazz, 0);
    }

    @Nullable
    public <CONTAINER extends Container> CONTAINER getSubContainer(Class<CONTAINER> clazz, int index) {
        for (Container sub : this.subContainers) {
            if (clazz.isAssignableFrom(sub.getClass())) {
                --index;
            }
            if (index >= 0) continue;
            return (CONTAINER)((Container)clazz.cast(sub));
        }
        return null;
    }

    public Container getSlotContainer(int slotNumber) {
        if (this.slotContainerMap.containsKey(slotNumber)) {
            return this.slotContainerMap.get(slotNumber);
        }
        return this;
    }

    @Override
    public boolean func_75145_c(PlayerEntity playerIn) {
        for (Container sub : this.subContainers) {
            if (sub.func_75145_c(playerIn)) continue;
            return false;
        }
        return super.func_75145_c(playerIn);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        for (Container sub : this.subContainers) {
            sub.func_75134_a(playerIn);
        }
        super.func_75134_a(playerIn);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType type, PlayerEntity player) {
        if (slotId == -999 && type == ClickType.QUICK_CRAFT) {
            for (Container container : this.subContainers) {
                container.func_184996_a(slotId, dragType, type, player);
            }
        }
        return super.func_184996_a(slotId, dragType, type, player);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = slot.func_75211_c().func_77946_l();
        ItemStack itemstack = slot.func_75211_c().func_77946_l();
        Container container = this.getSlotContainer(index);
        boolean nothingDone = true;
        if (container != this) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToPlayerInventory(itemstack);
        } else if (index < this.subContainerSlotStart || index < this.playerInventoryStart && this.subContainerSlotStart < 0) {
            nothingDone &= this.refillAnyContainer(itemstack, this.subContainers);
            nothingDone &= this.moveToPlayerInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else if (index >= this.playerInventoryStart && this.playerInventoryStart >= 0) {
            nothingDone &= this.moveToTileInventory(itemstack);
            nothingDone &= this.moveToAnyContainer(itemstack, this.subContainers);
        } else {
            return ItemStack.field_190927_a;
        }
        if (nothingDone) {
            return ItemStack.field_190927_a;
        }
        return this.notifySlotAfterTransfer(playerIn, itemstack, ret, slot);
    }

    protected ItemStack notifySlotAfterTransfer(PlayerEntity player, ItemStack stack, ItemStack original, Slot slot) {
        slot.func_75220_a(stack, original);
        if (stack.func_190916_E() == original.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75215_d(stack);
        slot.func_190901_a(player, stack);
        if (slot.func_75216_d() && slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return original;
    }

    protected boolean moveToTileInventory(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        int end = this.subContainerSlotStart;
        if (end < 0) {
            end = this.playerInventoryStart;
        }
        return !this.func_75135_a(itemstack, 0, end, false);
    }

    protected boolean moveToPlayerInventory(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        return this.playerInventoryStart > 0 && !this.func_75135_a(itemstack, this.playerInventoryStart, this.field_75151_b.size(), true);
    }

    protected boolean moveToAnyContainer(ItemStack itemstack, Collection<Container> containers) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        for (Container submodule : containers) {
            if (!this.moveToContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean moveToContainer(ItemStack itemstack, Container container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.func_75135_a(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    protected boolean refillAnyContainer(ItemStack itemstack, Collection<Container> containers) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        for (Container submodule : containers) {
            if (!this.refillContainer(itemstack, submodule)) continue;
            return true;
        }
        return false;
    }

    protected boolean refillContainer(ItemStack itemstack, Container container) {
        Pair<Integer, Integer> range = this.subContainerSlotRanges.get(container);
        return !this.mergeItemStackRefill(itemstack, (Integer)range.getLeft(), (Integer)range.getRight(), false);
    }

    @Nullable
    public <TE extends TileEntity> TE detectTE(Class<TE> clazz) {
        if (this.tile == null) {
            return null;
        }
        return (TE)((TileEntity)ObjectUtils.firstNonNull((Object[])new TileEntity[]{this.detectChest(this.tile.func_174877_v().func_177978_c(), clazz), this.detectChest(this.tile.func_174877_v().func_177974_f(), clazz), this.detectChest(this.tile.func_174877_v().func_177968_d(), clazz), this.detectChest(this.tile.func_174877_v().func_177976_e(), clazz)}));
    }

    @Nullable
    private <TE extends TileEntity> TE detectChest(BlockPos pos, Class<TE> clazz) {
        if (this.tile == null) {
            return null;
        }
        if (this.tile.func_145831_w() == null) {
            return null;
        }
        TileEntity te = this.tile.func_145831_w().func_175625_s(pos);
        if (clazz.isInstance(te)) {
            return (TE)((TileEntity)clazz.cast(te));
        }
        return null;
    }
}

