/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector4f;

public class Vector3i {
    public static final Vector3i ZERO = new Vector3i();
    public final int X;
    public final int Y;
    public final int Z;

    public Vector3i(int x, int y, int z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Vector3i(Vector3i other) {
        this(other.X, other.Y, other.Z);
    }

    public static Vector3i from(net.minecraft.util.math.vector.Vector3i data) {
        return new Vector3i(data.func_177958_n(), data.func_177956_o(), data.func_177952_p());
    }

    public static Vector3i from(Vector4f data) {
        return new Vector3i((int)data.func_195910_a(), (int)data.func_195913_b(), (int)data.func_195914_c());
    }

    public static Vector3i from(Entity data) {
        return new Vector3i((int)data.func_226277_ct_(), (int)data.func_226278_cu_(), (int)data.func_226281_cx_());
    }

    public static Vector3i from(TileEntity data) {
        return Vector3i.from((net.minecraft.util.math.vector.Vector3i)data.func_174877_v());
    }

    public static Vector3i syncDataFrom(CompoundNBT data) {
        return new Vector3i(data.func_74762_e("vx"), data.func_74762_e("vy"), data.func_74762_e("vz"));
    }

    public CompoundNBT syncDataTo(CompoundNBT data) {
        data.func_74768_a("vx", this.X);
        data.func_74768_a("vy", this.Y);
        data.func_74768_a("vz", this.Z);
        return data;
    }

    public net.minecraft.util.math.vector.Vector3i toVec3i() {
        return new net.minecraft.util.math.vector.Vector3i(this.X, this.Y, this.Z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.X, this.Y, this.Z);
    }

    public Vector3i add(int offsetX, int offsetY, int offsetZ) {
        return new Vector3i(this.X + offsetX, this.Y + offsetY, this.Z + offsetZ);
    }

    public Vector3i add(int offset) {
        return this.add(offset, offset, offset);
    }

    public Vector3i add(Vector3d offset) {
        return this.add((int)offset.X, (int)offset.Y, (int)offset.X);
    }

    public Vector3i add(net.minecraft.util.math.vector.Vector3i offset) {
        return this.add(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
    }

    public Vector3i subtract(int offsetX, int offsetY, int offsetZ) {
        return new Vector3i(this.X - offsetX, this.Y - offsetY, this.Z - offsetZ);
    }

    public Vector3i subtract(int offset) {
        return this.subtract(offset, offset, offset);
    }

    public Vector3i subtract(Vector3i offset) {
        return this.subtract(offset.X, offset.Y, offset.Z);
    }

    public Vector3i multiply(int factorX, int factorY, int factorZ) {
        return new Vector3i(this.X * factorX, this.Y * factorY, this.Z * factorZ);
    }

    public Vector3i multiply(double factorX, double factorY, double factorZ) {
        return new Vector3i((int)((double)this.X * factorX), (int)((double)this.Y * factorY), (int)((double)this.Z * factorZ));
    }

    public Vector3i multiply(int factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3i multiply(double factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3i multiply(Vector3i factor) {
        return this.multiply(factor.X, factor.Y, factor.Z);
    }

    public Vector3i divide(int factorX, int factorY, int factorZ) {
        return new Vector3i(this.X / factorX, this.Y / factorY, this.Z / factorZ);
    }

    public Vector3i divide(double factorX, double factorY, double factorZ) {
        return new Vector3i((int)((double)this.X / factorX), (int)((double)this.Y / factorY), (int)((double)this.Z / factorZ));
    }

    public Vector3i divide(int factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3i divide(double factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3i divide(net.minecraft.util.math.vector.Vector3i factor) {
        return this.divide(factor.func_177958_n(), factor.func_177956_o(), factor.func_177952_p());
    }

    public Vector3i ceil() {
        return new Vector3i(MathHelper.func_76123_f((float)this.X), MathHelper.func_76123_f((float)this.Y), MathHelper.func_76123_f((float)this.Z));
    }

    public Vector3i floor() {
        return new Vector3i(MathHelper.func_76141_d((float)this.X), MathHelper.func_76141_d((float)this.Y), MathHelper.func_76141_d((float)this.Z));
    }

    public Vector3i crossProduct(Vector3i vec) {
        return new Vector3i(this.Y * vec.Z - this.Z * vec.Y, this.Z * vec.X - this.X * vec.Z, this.X * vec.Y - this.Y * vec.X);
    }

    public double magnitude() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public Vector3i normalize() {
        double magnitude = this.magnitude();
        if (0.0 != magnitude) {
            return this.multiply(1.0 / magnitude);
        }
        return this;
    }

    public int scalarProduct(int x, int y, int z) {
        return this.X * x + this.Y * y + this.Z * z;
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3i) {
            Vector3i v = (Vector3i)other;
            return this.X == v.X && this.Y == v.Y && this.Z == v.Z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.X, this.Y, this.Z);
    }

    public String toString() {
        return String.format("Vector3i (%d, %d, %d)", this.X, this.Y, this.Z);
    }

    private Vector3i() {
        this.Z = 0;
        this.Y = 0;
        this.X = 0;
    }
}

