/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock;

import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IActivableMachine;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.lib.multiblock.registry.MultiblockRegistry;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;

public abstract class AbstractMultiblockPart<Controller extends IMultiblockController<Controller>>
extends AbstractModBlockEntity
implements IMultiblockPart<Controller>,
IDebuggable {
    private Runnable onDataUpdateHandler;
    private Controller _controller = null;
    private boolean _unvisited = true;
    private boolean _saveMultiblockData = false;
    private CompoundNBT _cachedMultiblockData = null;
    private long _positionHash = this.field_174879_c.func_218275_a();

    public AbstractMultiblockPart(TileEntityType<?> type) {
        super(type);
    }

    public World getPartWorldOrFail() {
        World world = this.func_145831_w();
        if (null == world) {
            throw new IllegalStateException("Found a multiblock part without a world!");
        }
        return world;
    }

    @Override
    public boolean isConnected() {
        return null != this._controller;
    }

    @Override
    public boolean isMachineAssembled() {
        return this.isConnected() && this._controller.isAssembled();
    }

    @Override
    public boolean isMachineDisassembled() {
        return this.isConnected() && this._controller.isDisassembled();
    }

    @Override
    public boolean isMachinePaused() {
        return this.isConnected() && this._controller.isPaused();
    }

    @Override
    public Optional<Controller> getMultiblockController() {
        return Optional.ofNullable(this._controller);
    }

    @Override
    public void executeOnController(Consumer<Controller> code) {
        if (null != this._controller) {
            code.accept(this._controller);
        }
    }

    @Override
    public <R> R evalOnController(Function<Controller, R> code, R defaultValue) {
        return null != this._controller ? code.apply(this._controller) : defaultValue;
    }

    @Override
    public boolean testOnController(Predicate<Controller> test) {
        return null != this._controller && test.test(this._controller);
    }

    @Override
    public Optional<World> getPartWorld() {
        return Optional.ofNullable(this.func_145831_w());
    }

    @Override
    public <T> T mapPartWorld(Function<World, T> mapper, T defaultValue) {
        World world = this.func_145831_w();
        return null != world ? mapper.apply(world) : defaultValue;
    }

    @Override
    public void forPartWorld(Consumer<World> consumer) {
        World world = this.func_145831_w();
        if (null != world) {
            consumer.accept(world);
        }
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.func_174877_v();
    }

    @Override
    public long getWorldPositionHash() {
        return this._positionHash;
    }

    @Override
    public boolean isPartInvalid() {
        return this.func_145837_r();
    }

    @Override
    public void onAttached(Controller newController) {
        this._controller = newController;
    }

    @Override
    public void onDetached(Controller oldController) {
        this._controller = null;
    }

    @Override
    public void onOrphaned(Controller controller, int oldSize, int newSize) {
        this.func_70296_d();
    }

    @Override
    public void onAssimilated(Controller newController) {
        assert (this._controller != newController);
        this._controller = newController;
    }

    @Override
    public void setVisited() {
        this._unvisited = false;
    }

    @Override
    public void setUnvisited() {
        this._unvisited = true;
    }

    @Override
    public boolean isVisited() {
        return !this._unvisited;
    }

    @Override
    public boolean isNotVisited() {
        return this._unvisited;
    }

    @Override
    public void becomeMultiblockSaveDelegate() {
        this._saveMultiblockData = true;
    }

    @Override
    public void forfeitMultiblockSaveDelegate() {
        this._saveMultiblockData = false;
    }

    @Override
    public boolean isMultiblockSaveDelegate() {
        return this._saveMultiblockData;
    }

    @Override
    public List<IMultiblockPart<Controller>> getNeighboringParts() {
        BlockPos[] positions;
        World world = this.func_145831_w();
        if (null == world) {
            return Collections.emptyList();
        }
        ReferenceArrayList parts = new ReferenceArrayList(6);
        for (BlockPos position : positions = WorldHelper.getNeighboringPositionsList(this.getWorldPosition(), new BlockPos[6])) {
            TileEntity te = WorldHelper.getLoadedTile((IWorldReader)world, position);
            if (!(te instanceof IMultiblockPart)) continue;
            parts.add((IMultiblockPart)te);
        }
        return parts;
    }

    @Override
    public Set<Controller> attachToNeighbors(Function<IMultiblockPart<Controller>, Set<Controller>> controllersLookup) {
        Set<Controller> foundControllers = controllersLookup.apply(this);
        switch (foundControllers.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                this._controller = (IMultiblockController)foundControllers.iterator().next();
                this._controller.attachPart(this);
                return foundControllers;
            }
        }
        ReferenceArraySet candidateControllers = new ReferenceArraySet(6);
        IMultiblockController bestController = null;
        for (IMultiblockController controller : foundControllers) {
            if (null == bestController || !candidateControllers.contains(controller) && controller.shouldConsumeController(bestController)) {
                bestController = controller;
            }
            candidateControllers.add(controller);
        }
        if (null != bestController) {
            this._controller = bestController;
            bestController.attachPart(this);
        }
        return candidateControllers;
    }

    @Override
    public void assertDetached() {
        if (null != this._controller) {
            BlockPos coord = this.getWorldPosition();
            Log.LOGGER.info(Log.MULTIBLOCK, "[assert] Part @ ({}, {}, {}) should be detached already, but detected that it was not. This is not a fatal error, and will be repaired, but is unusual.", (Object)coord.func_177958_n(), (Object)coord.func_177956_o(), (Object)coord.func_177952_p());
            this._controller = null;
        }
    }

    @Override
    public boolean hasMultiblockSaveData() {
        return null != this._cachedMultiblockData;
    }

    @Override
    public Optional<CompoundNBT> getMultiblockSaveData() {
        return Optional.ofNullable(this._cachedMultiblockData);
    }

    @Override
    public <T> T mapMultiblockSaveData(Function<CompoundNBT, T> mapper, T defaultValue) {
        return null != this._cachedMultiblockData ? mapper.apply(this._cachedMultiblockData) : defaultValue;
    }

    @Override
    public void forMultiblockSaveData(Consumer<CompoundNBT> consumer) {
        if (null != this._cachedMultiblockData) {
            consumer.accept(this._cachedMultiblockData);
        }
    }

    @Override
    public void onMultiblockDataAssimilated() {
        this._cachedMultiblockData = null;
    }

    @Override
    public void listenForControllerDataUpdates() {
        this.onDataUpdateHandler = this.getMultiblockController().map(controller -> controller.listenForDataUpdate(this::onDataUpdate)).orElse(null);
    }

    public void unlistenForControllerDataUpdates() {
        if (null != this.onDataUpdateHandler) {
            this.getMultiblockController().ifPresent(controller -> controller.unlistenForDataUpdate(this.onDataUpdateHandler));
            this.onDataUpdateHandler = null;
        }
    }

    @Override
    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        this._positionHash = this.field_174879_c.func_218275_a();
        if (data.func_74764_b("multiblockData")) {
            CompoundNBT multiblockData = data.func_74775_l("multiblockData");
            switch (syncReason) {
                case FullSync: {
                    this._cachedMultiblockData = multiblockData;
                    break;
                }
                case NetworkUpdate: {
                    CodeHelper.optionalIfPresentOrElse(this.getMultiblockController(), c -> c.syncFromSaveDelegate(multiblockData, syncReason), () -> {
                        this._cachedMultiblockData = multiblockData;
                    });
                }
            }
        }
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        if (this.isMultiblockSaveDelegate()) {
            this.getMultiblockController().ifPresent(c -> data.func_218657_a("multiblockData", (INBT)c.syncDataTo(new CompoundNBT(), syncReason)));
        }
        return data;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        CodeHelper.optionalIfPresentOrElse(this.getMultiblockController(), controller -> this.getControllerDebugMessages(side, controller, messages), () -> messages.addUnlocalized("Part not attached to a controller"));
    }

    private void getControllerDebugMessages(LogicalSide side, Controller controller, IDebugMessages messages) {
        messages.addUnlocalized("Multiblock controller class: %1$s", controller.getClass().getSimpleName());
        messages.addUnlocalized("Attached parts: %1$d; Assembled: %2$s", controller.getPartsCount(), controller.isAssembled());
        controller.getReferenceCoord().ifPresent(position -> messages.addUnlocalized("Reference coordinates %s", position.toString()));
        messages.addUnlocalized(controller.getBoundingBox().toString());
        if (controller instanceof IActivableMachine) {
            messages.addUnlocalized("Active: %1$s", ((IActivableMachine)controller).isMachineActive());
        }
        controller.getLastError().ifPresent(error -> messages.add(side, (IDebuggable)error, "Last validation error: "));
        if (controller instanceof IDebuggable) {
            ((IDebuggable)controller).getDebugMessages(side, messages);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.getRegistry().onPartAdded(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.detachSelf(false);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.detachSelf(true);
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        this._positionHash = this.field_174879_c.func_218275_a();
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this._positionHash = this.field_174879_c.func_218275_a();
    }

    @Deprecated
    protected void notifyNeighborsOfTileChange() {
    }

    protected void detachSelf(boolean chunkUnloading) {
        if (this._controller != null) {
            this._controller.detachPart(this, chunkUnloading);
            this._controller = null;
        }
        this.getRegistry().onPartRemovedFromWorld(this);
    }

    private IMultiblockRegistry<Controller> getRegistry() {
        return MultiblockRegistry.INSTANCE;
    }
}

