/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.recipe.ISerializableRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractTwoToOneRecipe<Ingredient1, Ingredient2, Result, RecipeIngredient1 extends IRecipeIngredient<Ingredient1>, RecipeIngredient2 extends IRecipeIngredient<Ingredient2>, RecipeResult extends IRecipeResult<Result>>
extends ModRecipe
implements BiPredicate<Ingredient1, Ingredient2>,
ISerializableRecipe {
    private final RecipeIngredient1 _ingredient1;
    private final RecipeIngredient2 _ingredient2;
    private final RecipeResult _result;
    private final IntFunction<String> _jsonIngredientsLabelsSupplier;

    protected AbstractTwoToOneRecipe(ResourceLocation id, RecipeIngredient1 ingredient1, RecipeIngredient2 ingredient2, RecipeResult result, IntFunction<String> jsonIngredientsLabelsSupplier) {
        super(id);
        this._ingredient1 = ingredient1;
        this._ingredient2 = ingredient2;
        this._result = result;
        this._jsonIngredientsLabelsSupplier = jsonIngredientsLabelsSupplier;
    }

    public RecipeIngredient1 getIngredient1() {
        return this._ingredient1;
    }

    public RecipeIngredient2 getIngredient2() {
        return this._ingredient2;
    }

    public RecipeResult getResult() {
        return this._result;
    }

    @Override
    public boolean test(Ingredient1 stack1, Ingredient2 stack2) {
        return this.getIngredient1().test(stack1) && this.getIngredient2().test(stack2);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return AbstractTwoToOneRecipe.buildVanillaIngredientsList(this.getIngredient1().asVanillaIngredients(), this.getIngredient2().asVanillaIngredients());
    }

    @Override
    public void serializeTo(PacketBuffer buffer) {
        this._ingredient1.serializeTo(buffer);
        this._ingredient2.serializeTo(buffer);
        this._result.serializeTo(buffer);
    }

    @Override
    public JsonElement serializeTo() {
        JsonObject json = new JsonObject();
        json.add(this._jsonIngredientsLabelsSupplier.apply(0), this._ingredient1.serializeTo());
        json.add(this._jsonIngredientsLabelsSupplier.apply(1), this._ingredient2.serializeTo());
        json.add("result", this._result.serializeTo());
        return json;
    }

    @FunctionalInterface
    public static interface IRecipeFactory<Ingredient1, Ingredient2, Result, RecipeIngredient1 extends IRecipeIngredient<Ingredient1>, RecipeIngredient2 extends IRecipeIngredient<Ingredient2>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractTwoToOneRecipe<Ingredient1, Ingredient2, Result, RecipeIngredient1, RecipeIngredient2, RecipeResult>> {
        public Recipe create(ResourceLocation var1, RecipeIngredient1 var2, RecipeIngredient2 var3, RecipeResult var4);
    }
}

