/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractNumberListEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class FloatListEntry
extends AbstractNumberListEntry<Float> {
    @Deprecated
    @ApiStatus.Internal
    public FloatListEntry(ITextComponent fieldName, Float value, ITextComponent resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveCallback = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public FloatListEntry(ITextComponent fieldName, Float value, ITextComponent resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public FloatListEntry(ITextComponent fieldName, Float value, ITextComponent resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveCallback = saveConsumer;
    }

    @Override
    protected Map.Entry<Float, Float> getDefaultRange() {
        return new AbstractMap.SimpleEntry<Float, Float>(Float.valueOf(-3.4028235E38f), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatListEntry setMinimum(float minimum) {
        this.minimum = Float.valueOf(minimum);
        return this;
    }

    public FloatListEntry setMaximum(float maximum) {
        this.maximum = Float.valueOf(maximum);
        return this;
    }

    @Override
    public Float getValue() {
        try {
            return Float.valueOf(this.textFieldWidget.func_146179_b());
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public Optional<ITextComponent> getError() {
        try {
            float i = Float.parseFloat(this.textFieldWidget.func_146179_b());
            if (i > ((Float)this.maximum).floatValue()) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_large", new Object[]{this.maximum}));
            }
            if (i < ((Float)this.minimum).floatValue()) {
                return Optional.of(new TranslationTextComponent("text.cloth-config.error.too_small", new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(new TranslationTextComponent("text.cloth-config.error.not_valid_number_float"));
        }
        return super.getError();
    }
}

