/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FocusableGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicEntryListWidget<E extends Entry<E>>
extends FocusableGui
implements IRenderable {
    protected static final int DRAG_OUTSIDE = -2;
    protected final Minecraft client;
    private final List<E> entries = new Entries();
    public int width;
    public int height;
    public int top;
    public int bottom;
    public int right;
    public int left;
    protected boolean verticallyCenter = true;
    protected int yDrag = -2;
    protected boolean selectionVisible = true;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    protected E selectedItem;
    protected ResourceLocation backgroundLocation;

    public DynamicEntryListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.backgroundLocation = backgroundLocation;
    }

    public void setRenderSelection(boolean boolean_1) {
        this.selectionVisible = boolean_1;
    }

    protected void setRenderHeader(boolean boolean_1, int headerHeight) {
        this.renderSelection = boolean_1;
        this.headerHeight = headerHeight;
        if (!boolean_1) {
            this.headerHeight = 0;
        }
    }

    public int getItemWidth() {
        return 220;
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    public void selectItem(E item) {
        this.selectedItem = item;
    }

    public E getFocused() {
        return (E)((Object)((Entry)super.func_241217_q_()));
    }

    public List<E> func_231039_at__() {
        return this.entries;
    }

    protected final void clearItems() {
        this.func_231039_at__().clear();
    }

    protected E getItem(int index) {
        return (E)((Object)((Entry)((Object)this.func_231039_at__().get(index))));
    }

    protected int addItem(E item) {
        this.func_231039_at__().add(item);
        return this.func_231039_at__().size() - 1;
    }

    protected int getItemCount() {
        return this.func_231039_at__().size();
    }

    protected boolean isSelected(int index) {
        return Objects.equals(this.getSelectedItem(), this.func_231039_at__().get(index));
    }

    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = MathHelper.func_76128_c((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.func_231039_at__().size(); ++i) {
            E item = this.getItem(i);
            if ((itemY += ((Entry)((Object)item)).getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return (E)((Object)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? (Entry)((Object)this.func_231039_at__().get(itemIndex)) : null));
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxScrollPosition() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = this.headerHeight;
        for (Entry entry : this.func_231039_at__()) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0);
    }

    protected void clickedHeader(int int_1, int int_2) {
    }

    protected void renderHeader(MatrixStack matrices, int rowLeft, int startY, Tessellator tessellator) {
    }

    protected void drawBackground() {
    }

    protected void renderDecorations(MatrixStack matrices, int mouseX, int mouseY) {
    }

    @Deprecated
    protected void renderBackBackground(MatrixStack matrices, BufferBuilder buffer, Tessellator tessellator) {
        this.client.func_110434_K().func_110577_a(this.backgroundLocation);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        float float_2 = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, (float)this.left, (float)this.bottom, 0.0f).func_225583_a_((float)this.left / 32.0f, (float)(this.bottom + (int)this.getScroll()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.right, (float)this.bottom, 0.0f).func_225583_a_((float)this.right / 32.0f, (float)(this.bottom + (int)this.getScroll()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.right, (float)this.top, 0.0f).func_225583_a_((float)this.right / 32.0f, (float)(this.top + (int)this.getScroll()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.left, (float)this.top, 0.0f).func_225583_a_((float)this.left / 32.0f, (float)(this.top + (int)this.getScroll()) / 32.0f).func_225586_a_(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollbarPosition = this.getScrollbarPosition();
        int int_4 = scrollbarPosition + 6;
        RenderSystem.disableLighting();
        RenderSystem.disableFog();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.renderBackBackground(matrices, buffer, tessellator);
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int)this.getScroll();
        if (this.renderSelection) {
            this.renderHeader(matrices, rowLeft, startY, tessellator);
        }
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.left, this.top, this.width, this.bottom - this.top));
        this.renderList(matrices, rowLeft, startY, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.removeLastScissor();
        RenderSystem.disableDepthTest();
        this.renderHoleBackground(matrices, 0, this.top, 255, 255);
        this.renderHoleBackground(matrices, this.bottom, this.height, 255, 255);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, (float)this.left, (float)(this.top + 4), 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.right, (float)(this.top + 4), 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.right, (float)this.top, 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.left, (float)this.top, 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, (float)this.left, (float)this.bottom, 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.right, (float)this.bottom, 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.right, (float)(this.bottom - 4), 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.left, (float)(this.bottom - 4), 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
        tessellator.func_78381_a();
        int maxScroll = this.getMaxScroll();
        this.renderScrollBar(matrices, tessellator, buffer, maxScroll, scrollbarPosition, int_4);
        this.renderDecorations(matrices, mouseX, mouseY);
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    protected void renderScrollBar(MatrixStack matrices, Tessellator tessellator, BufferBuilder buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int int_9 = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            int_9 = MathHelper.func_76125_a((int)int_9, (int)32, (int)(this.bottom - this.top - 8));
            int int_10 = (int)this.getScroll() * (this.bottom - this.top - int_9) / maxScroll + this.top;
            if (int_10 < this.top) {
                int_10 = this.top;
            }
            Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)this.bottom, 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)this.bottom, 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)this.top, 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)this.top, 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)(int_10 + int_9), 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)(int_10 + int_9), 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMaxX, (float)int_10, 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            buffer.func_227888_a_(matrix, (float)scrollbarPositionMinX, (float)int_10, 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)(int_10 + int_9 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buffer.func_225582_a_((double)(scrollbarPositionMaxX - 1), (double)(int_10 + int_9 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buffer.func_225582_a_((double)(scrollbarPositionMaxX - 1), (double)int_10, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            buffer.func_225582_a_((double)scrollbarPositionMinX, (double)int_10, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    protected void centerScrollOn(E item) {
        double d = (double)(this.bottom - this.top) / -2.0;
        for (int i = 0; i < this.func_231039_at__().indexOf(item) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)((Object)this.getItem(i))).getItemHeight();
        }
        this.capYPosition(d);
    }

    protected void ensureVisible(E item) {
        int int_3;
        int rowTop = this.getRowTop(this.func_231039_at__().indexOf(item));
        int int_2 = rowTop - this.top - 4 - ((Entry)((Object)item)).getItemHeight();
        if (int_2 < 0) {
            this.scroll(int_2);
        }
        if ((int_3 = this.bottom - rowTop - ((Entry)((Object)item)).getItemHeight() * 2) < 0) {
            this.scroll(-int_3);
        }
    }

    protected void scroll(int int_1) {
        this.capYPosition(this.getScroll() + (double)int_1);
        this.yDrag = -2;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void capYPosition(double double_1) {
        this.scroll = MathHelper.func_151237_a((double)double_1, (double)0.0, (double)this.getMaxScroll());
    }

    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScroll() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean func_231044_a_(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.func_231047_b_(double_1, double_2)) {
            return false;
        }
        E item = this.getItemAtPosition(double_1, double_2);
        if (item != null) {
            if (item.func_231044_a_(double_1, double_2, int_1)) {
                this.func_231035_a_((IGuiEventListener)item);
                this.func_231037_b__(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.clickedHeader((int)(double_1 - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(double_2 - (double)this.top) + (int)this.getScroll() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean func_231048_c_(double double_1, double double_2, int int_1) {
        if (this.getFocused() != null) {
            this.getFocused().func_231048_c_(double_1, double_2, int_1);
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.capYPosition(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = MathHelper.func_76125_a((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(this.getScroll() + deltaY * double_6);
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double double_1, double double_2, double double_3) {
        for (Entry entry : this.func_231039_at__()) {
            if (!entry.func_231043_a_(double_1, double_2, double_3)) continue;
            return true;
        }
        this.capYPosition(this.getScroll() - double_3 * (double)(this.getMaxScroll() / this.getItemCount()) / 2.0);
        return true;
    }

    public boolean func_231046_a_(int int_1, int int_2, int int_3) {
        if (super.func_231046_a_(int_1, int_2, int_3)) {
            return true;
        }
        if (int_1 == 264) {
            this.moveSelection(1);
            return true;
        }
        if (int_1 == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int int_1) {
        if (!this.func_231039_at__().isEmpty()) {
            int int_2 = this.func_231039_at__().indexOf(this.getSelectedItem());
            int int_3 = MathHelper.func_76125_a((int)(int_2 + int_1), (int)0, (int)(this.getItemCount() - 1));
            Entry itemListWidget$Item_1 = (Entry)((Object)this.func_231039_at__().get(int_3));
            this.selectItem(itemListWidget$Item_1);
            this.ensureVisible(itemListWidget$Item_1);
        }
    }

    public boolean func_231047_b_(double double_1, double double_2) {
        return double_2 >= (double)this.top && double_2 <= (double)this.bottom && double_1 >= (double)this.left && double_1 <= (double)this.right;
    }

    protected void renderList(MatrixStack matrices, int startX, int startY, int int_3, int int_4, float float_1) {
        int itemCount = this.getItemCount();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            int itemY = startY + this.headerHeight;
            for (int i = 0; i < this.func_231039_at__().size() && i < renderIndex; ++i) {
                itemY += ((Entry)((Object)this.func_231039_at__().get(i))).getItemHeight();
            }
            int itemHeight = ((Entry)((Object)item)).getItemHeight() - 4;
            int itemWidth = this.getItemWidth();
            if (this.selectionVisible && this.isSelected(renderIndex)) {
                int itemMinX = this.left + this.width / 2 - itemWidth / 2;
                int itemMaxX = itemMinX + itemWidth;
                RenderSystem.disableTexture();
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_227888_a_(matrix, (float)itemMinX, (float)(itemY + itemHeight + 2), 0.0f).func_227885_a_(float_2, float_2, float_2, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)itemMaxX, (float)(itemY + itemHeight + 2), 0.0f).func_227885_a_(float_2, float_2, float_2, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)itemMaxX, (float)(itemY - 2), 0.0f).func_227885_a_(float_2, float_2, float_2, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)itemMinX, (float)(itemY - 2), 0.0f).func_227885_a_(float_2, float_2, float_2, 1.0f).func_181675_d();
                tessellator.func_78381_a();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                buffer.func_227888_a_(matrix, (float)(itemMinX + 1), (float)(itemY + itemHeight + 1), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)(itemMaxX - 1), (float)(itemY + itemHeight + 1), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)(itemMaxX - 1), (float)(itemY - 1), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, (float)(itemMinX + 1), (float)(itemY - 1), 0.0f).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                tessellator.func_78381_a();
                RenderSystem.enableTexture();
            }
            int y = this.getRowTop(renderIndex);
            int x = this.getRowLeft();
            RenderHelper.func_74518_a();
            this.renderItem(matrices, item, renderIndex, y, x, itemWidth, itemHeight, int_3, int_4, this.func_231047_b_(int_3, int_4) && Objects.equals(this.getItemAtPosition(int_3, int_4), item), float_1);
        }
    }

    protected void renderItem(MatrixStack matrices, E item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        ((Entry)((Object)item)).render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getItemWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        int integer = this.top + 4 - (int)this.getScroll() + this.headerHeight;
        for (int i = 0; i < this.func_231039_at__().size() && i < index; ++i) {
            integer += ((Entry)((Object)this.func_231039_at__().get(i))).getItemHeight();
        }
        return integer;
    }

    protected boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(MatrixStack matrices, int y1, int y2, int alpha1, int alpha2) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.client.func_110434_K().func_110577_a(this.backgroundLocation);
        Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float float_1 = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, (float)this.left, (float)y2, 0.0f).func_225583_a_(0.0f, (float)y2 / 32.0f).func_225586_a_(64, 64, 64, alpha2).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.left + this.width), (float)y2, 0.0f).func_225583_a_((float)this.width / 32.0f, (float)y2 / 32.0f).func_225586_a_(64, 64, 64, alpha2).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.left + this.width), (float)y1, 0.0f).func_225583_a_((float)this.width / 32.0f, (float)y1 / 32.0f).func_225586_a_(64, 64, 64, alpha1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)this.left, (float)y1, 0.0f).func_225583_a_(0.0f, (float)y1 / 32.0f).func_225586_a_(64, 64, 64, alpha1).func_181675_d();
        tessellator.func_78381_a();
    }

    protected E remove(int int_1) {
        Entry itemListWidget$Item_1 = (Entry)((Object)this.func_231039_at__().get(int_1));
        return (E)((Object)(this.removeEntry((Entry)((Object)this.func_231039_at__().get(int_1))) ? itemListWidget$Item_1 : null));
    }

    protected boolean removeEntry(E itemListWidget$Item_1) {
        boolean boolean_1 = this.func_231039_at__().remove(itemListWidget$Item_1);
        if (boolean_1 && itemListWidget$Item_1 == this.getSelectedItem()) {
            this.selectItem(null);
        }
        return boolean_1;
    }

    @OnlyIn(value=Dist.CLIENT)
    class Entries
    extends AbstractList<E> {
        private final ArrayList<E> items = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public void clear() {
            this.items.clear();
        }

        @Override
        public E get(int int_1) {
            return (Object)((Entry)((Object)this.items.get(int_1)));
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public E set(int int_1, E itemListWidget$Item_1) {
            Entry itemListWidget$Item_2 = (Entry)((Object)this.items.set(int_1, itemListWidget$Item_1));
            ((Entry)((Object)itemListWidget$Item_1)).parent = DynamicEntryListWidget.this;
            return (Object)itemListWidget$Item_2;
        }

        @Override
        public void add(int int_1, E itemListWidget$Item_1) {
            this.items.add(int_1, itemListWidget$Item_1);
            ((Entry)((Object)itemListWidget$Item_1)).parent = DynamicEntryListWidget.this;
        }

        @Override
        public E remove(int int_1) {
            return (Object)((Entry)((Object)this.items.remove(int_1)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry<E extends Entry<E>>
    extends AbstractGui
    implements IGuiEventListener {
        @Deprecated
        DynamicEntryListWidget<E> parent;

        public abstract void render(MatrixStack var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean func_231047_b_(double double_1, double double_2) {
            return Objects.equals(this.parent.getItemAtPosition(double_1, double_2), (Object)this);
        }

        public DynamicEntryListWidget<E> getParent() {
            return this.parent;
        }

        public void setParent(DynamicEntryListWidget<E> parent) {
            this.parent = parent;
        }

        public abstract int getItemHeight();

        @Deprecated
        public int getMorePossibleHeight() {
            return -1;
        }
    }

    public static final class SmoothScrollingSettings {
        public static final double CLAMP_EXTENSION = 200.0;

        private SmoothScrollingSettings() {
        }
    }
}

