/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer;

import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.common.valuecontainer.AbstractVectorValueContainerEntry;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.math.NumberUtils;

public class Vector3iValueContainerEntry
extends AbstractVectorValueContainerEntry<Vector3i> {
    public Vector3iValueContainerEntry(ITextComponent displayName, String name, Vector3i value) {
        this(displayName, name, value, null, null);
    }

    public Vector3iValueContainerEntry(ITextComponent displayName, String name, Vector3i value, Vector3i minValue, Vector3i maxValue) {
        super(displayName, name, value, minValue, maxValue, false);
    }

    @Override
    protected Vector3i create(Number x, Number y, Number z) {
        return new Vector3i(x.intValue(), y.intValue(), z.intValue());
    }

    @Override
    protected Number getX(Vector3i value) {
        return value.func_177958_n();
    }

    @Override
    protected Number getY(Vector3i value) {
        return value.func_177956_o();
    }

    @Override
    protected Number getZ(Vector3i value) {
        return value.func_177952_p();
    }

    @Override
    public void write(CompoundNBT nbt) {
        CompoundNBT valueNbt = new CompoundNBT();
        valueNbt.func_74768_a("x", ((Vector3i)this.value).func_177958_n());
        valueNbt.func_74768_a("y", ((Vector3i)this.value).func_177956_o());
        valueNbt.func_74768_a("z", ((Vector3i)this.value).func_177952_p());
        nbt.func_218657_a(this.getName(), (INBT)valueNbt);
    }

    @Override
    public void read(CompoundNBT nbt) {
        if (nbt.func_150297_b(this.getName(), 10)) {
            CompoundNBT valueNbt = nbt.func_74775_l(this.getName());
            this.value = new Vector3i(valueNbt.func_74762_e("x"), valueNbt.func_74762_e("y"), valueNbt.func_74762_e("z"));
        } else {
            this.value = new Vector3i(0, 0, 0);
        }
    }

    @Override
    public void parse(String data) {
        String[] tokens = String.valueOf(data).split(",");
        Number x = NumberUtils.createNumber((String)tokens[0].trim());
        Number y = NumberUtils.createNumber((String)tokens[1].trim());
        Number z = NumberUtils.createNumber((String)tokens[2].trim());
        this.value = this.clamp(new Vector3i(x.intValue(), y.intValue(), z.intValue()), this.getMinValue(), this.getMaxValue());
    }
}

