/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.compat.jei;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.FluidsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantsRegistry;
import it.zerono.mods.extremereactors.api.reactor.ReactionsRegistry;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.fluidizer.FluidizerRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.CoolantFromFluidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.CoolantIngredientHelper;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.CoolantIngredientRenderer;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantFromFluidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantFromSolidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantIngredientHelper;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactantIngredientRenderer;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.ReactionsRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.TransitionsRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.VaporFromFluidRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.VaporIngredientHelper;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor.VaporIngredientRenderer;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.reprocessor.ReprocessorRecipeCategory;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import java.util.Collection;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class ExtremeReactorsJeiPlugin
implements IModPlugin {
    public static final IIngredientType<Reactant> REACTANT_INGREDIENT_TYPE = () -> Reactant.class;
    public static final IIngredientType<Coolant> COOLANT_INGREDIENT_TYPE = () -> Coolant.class;
    public static final IIngredientType<Vapor> VAPOR_INGREDIENT_TYPE = () -> Vapor.class;
    private static final ResourceLocation s_id = ExtremeReactors.newID("jeiplugin");
    private ReactantFromSolidRecipeCategory _reactantsSolidMappings;
    private ReactantFromFluidRecipeCategory _reactantsFluidMappings;
    private TransitionsRecipeCategory<Coolant, Vapor, TransitionsRecipeCategory.VaporizationTransition> _vaporizations;
    private TransitionsRecipeCategory<Vapor, Coolant, TransitionsRecipeCategory.CondensationTransition> _condensations;
    private CoolantFromFluidRecipeCategory _coolantsMappings;
    private VaporFromFluidRecipeCategory _vaporsMappings;

    public ResourceLocation getPluginUid() {
        return s_id;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ReprocessorRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{FluidizerRecipeCategory.solid(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{FluidizerRecipeCategory.solidMixing(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{FluidizerRecipeCategory.fluidMixing(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ReactionsRecipeCategory(guiHelper)});
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this._reactantsSolidMappings = new ReactantFromSolidRecipeCategory(guiHelper);
        iRecipeCategoryArray[0] = this._reactantsSolidMappings;
        registration.addRecipeCategories(iRecipeCategoryArray);
        IRecipeCategory[] iRecipeCategoryArray2 = new IRecipeCategory[1];
        this._reactantsFluidMappings = new ReactantFromFluidRecipeCategory(guiHelper);
        iRecipeCategoryArray2[0] = this._reactantsFluidMappings;
        registration.addRecipeCategories(iRecipeCategoryArray2);
        IRecipeCategory[] iRecipeCategoryArray3 = new IRecipeCategory[1];
        this._vaporizations = TransitionsRecipeCategory.vaporization(guiHelper);
        iRecipeCategoryArray3[0] = this._vaporizations;
        registration.addRecipeCategories(iRecipeCategoryArray3);
        IRecipeCategory[] iRecipeCategoryArray4 = new IRecipeCategory[1];
        this._condensations = TransitionsRecipeCategory.condensation(guiHelper);
        iRecipeCategoryArray4[0] = this._condensations;
        registration.addRecipeCategories(iRecipeCategoryArray4);
        IRecipeCategory[] iRecipeCategoryArray5 = new IRecipeCategory[1];
        this._coolantsMappings = new CoolantFromFluidRecipeCategory(guiHelper);
        iRecipeCategoryArray5[0] = this._coolantsMappings;
        registration.addRecipeCategories(iRecipeCategoryArray5);
        IRecipeCategory[] iRecipeCategoryArray6 = new IRecipeCategory[1];
        this._vaporsMappings = new VaporFromFluidRecipeCategory(guiHelper);
        iRecipeCategoryArray6[0] = this._vaporsMappings;
        registration.addRecipeCategories(iRecipeCategoryArray6);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((Collection)Content.Recipes.REPROCESSOR_RECIPE_TYPE.getRecipes(), ReprocessorRecipe.ID);
        registration.addRecipes((Collection)Content.Recipes.FLUIDIZER_RECIPE_TYPE.getRecipes(r -> r instanceof FluidizerSolidRecipe), IFluidizerRecipe.Type.Solid.getRecipeId());
        registration.addRecipes((Collection)Content.Recipes.FLUIDIZER_RECIPE_TYPE.getRecipes(r -> r instanceof FluidizerSolidMixingRecipe), IFluidizerRecipe.Type.SolidMixing.getRecipeId());
        registration.addRecipes((Collection)Content.Recipes.FLUIDIZER_RECIPE_TYPE.getRecipes(r -> r instanceof FluidizerFluidMixingRecipe), IFluidizerRecipe.Type.FluidMixing.getRecipeId());
        registration.addRecipes(ReactionsRegistry.getReactions(), ReactionsRecipeCategory.ID);
        registration.addRecipes(this._reactantsSolidMappings.getReactants(), this._reactantsSolidMappings.getUid());
        registration.addRecipes(this._reactantsFluidMappings.getReactants(), this._reactantsFluidMappings.getUid());
        registration.addRecipes(this._vaporizations.getTransitions(), this._vaporizations.getUid());
        registration.addRecipes(this._condensations.getTransitions(), this._condensations.getUid());
        registration.addRecipes(this._coolantsMappings.getCoolants(), this._coolantsMappings.getUid());
        registration.addRecipes(this._vaporsMappings.getVapors(), this._vaporsMappings.getUid());
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(REACTANT_INGREDIENT_TYPE, ReactantsRegistry.getReactants(), (IIngredientHelper)new ReactantIngredientHelper(), (IIngredientRenderer)new ReactantIngredientRenderer());
        registration.register(COOLANT_INGREDIENT_TYPE, FluidsRegistry.getCoolants(), (IIngredientHelper)new CoolantIngredientHelper(), (IIngredientRenderer)new CoolantIngredientRenderer());
        registration.register(VAPOR_INGREDIENT_TYPE, FluidsRegistry.getVapors(), (IIngredientHelper)new VaporIngredientHelper(), (IIngredientRenderer)new VaporIngredientRenderer());
    }
}

