/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.compat.jei.reactor;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.api.IMapping;
import it.zerono.mods.extremereactors.api.coolant.Coolant;
import it.zerono.mods.extremereactors.api.coolant.TransitionsRegistry;
import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.compat.jei.ExtremeReactorsJeiPlugin;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.IOPortBlock;
import it.zerono.mods.zerocore.lib.compat.jei.AbstractModRecipeCategory;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TransitionsRecipeCategory<Input, Output, Recipe extends AbstractTransition<Input, Output>>
extends AbstractModRecipeCategory<Recipe> {
    private final Class<Recipe> _recipeClass;
    private final List<Recipe> _transitions;

    public static TransitionsRecipeCategory<Coolant, Vapor, VaporizationTransition> vaporization(IGuiHelper guiHelper) {
        return new TransitionsRecipeCategory<Coolant, Vapor, VaporizationTransition>(ExtremeReactors.newID("jei_vaporizations"), VaporizationTransition.class, "compat.bigreactors.jei.vaporization.recipecategory.title", ((IOPortBlock)Content.Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED.get()).createItemStack(), guiHelper, TransitionsRegistry.getVaporizations().values().stream().map(VaporizationTransition::new).collect(Collectors.toList()));
    }

    public static TransitionsRecipeCategory<Vapor, Coolant, CondensationTransition> condensation(IGuiHelper guiHelper) {
        return new TransitionsRecipeCategory<Vapor, Coolant, CondensationTransition>(ExtremeReactors.newID("jei_condensations"), CondensationTransition.class, "compat.bigreactors.jei.condensation.recipecategory.title", ((IOPortBlock)Content.Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED.get()).createItemStack(), guiHelper, TransitionsRegistry.getCondensations().values().stream().map(CondensationTransition::new).collect(Collectors.toList()));
    }

    public List<Recipe> getTransitions() {
        return this._transitions;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return this._recipeClass;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ((AbstractTransition)recipe).setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, Recipe recipe, IIngredients ingredients) {
        ((AbstractTransition)recipe).setRecipe(recipeLayout, ingredients);
    }

    protected TransitionsRecipeCategory(ResourceLocation id, Class<Recipe> recipeClass, String titleTranslationKey, ItemStack icon, IGuiHelper guiHelper, List<Recipe> transitions) {
        super(id, (ITextComponent)new TranslationTextComponent(titleTranslationKey), icon, guiHelper, (IDrawable)guiHelper.drawableBuilder(ExtremeReactors.newID("textures/gui/jei/mapping.png"), 0, 0, 144, 56).setTextureSize(144, 56).build());
        this._recipeClass = recipeClass;
        this._transitions = Objects.requireNonNull(transitions);
    }

    public static class CondensationTransition
    extends AbstractTransition<Vapor, Coolant> {
        public CondensationTransition(IMapping<Vapor, Coolant> mapping) {
            super(mapping);
        }

        @Override
        protected void setIngredients(IIngredients ingredients) {
            ingredients.setInput(ExtremeReactorsJeiPlugin.VAPOR_INGREDIENT_TYPE, this.getInput());
            ingredients.setOutput(ExtremeReactorsJeiPlugin.COOLANT_INGREDIENT_TYPE, this.getOutput());
        }

        @Override
        protected void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
            IGuiIngredientGroup input = recipeLayout.getIngredientsGroup(ExtremeReactorsJeiPlugin.VAPOR_INGREDIENT_TYPE);
            IGuiIngredientGroup output = recipeLayout.getIngredientsGroup(ExtremeReactorsJeiPlugin.COOLANT_INGREDIENT_TYPE);
            input.init(0, true, 33, 20);
            input.set(0, this.getInput());
            output.init(1, false, 95, 20);
            output.set(1, this.getOutput());
        }
    }

    public static class VaporizationTransition
    extends AbstractTransition<Coolant, Vapor> {
        public VaporizationTransition(IMapping<Coolant, Vapor> mapping) {
            super(mapping);
        }

        @Override
        protected void setIngredients(IIngredients ingredients) {
            ingredients.setInput(ExtremeReactorsJeiPlugin.COOLANT_INGREDIENT_TYPE, this.getInput());
            ingredients.setOutput(ExtremeReactorsJeiPlugin.VAPOR_INGREDIENT_TYPE, this.getOutput());
        }

        @Override
        protected void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
            IGuiIngredientGroup input = recipeLayout.getIngredientsGroup(ExtremeReactorsJeiPlugin.COOLANT_INGREDIENT_TYPE);
            IGuiIngredientGroup output = recipeLayout.getIngredientsGroup(ExtremeReactorsJeiPlugin.VAPOR_INGREDIENT_TYPE);
            input.init(0, true, 33, 20);
            input.set(0, this.getInput());
            output.init(1, false, 95, 20);
            output.set(1, this.getOutput());
        }
    }

    public static abstract class AbstractTransition<Input, Output> {
        private final IMapping<Input, Output> _mapping;

        protected AbstractTransition(IMapping<Input, Output> mapping) {
            this._mapping = Objects.requireNonNull(mapping);
        }

        public Input getInput() {
            return this._mapping.getSource();
        }

        public Output getOutput() {
            return this._mapping.getProduct();
        }

        protected abstract void setIngredients(IIngredients var1);

        protected abstract void setRecipe(IRecipeLayout var1, IIngredients var2);
    }
}

