/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import com.google.common.base.Strings;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.FuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ReactorControlRodEntity
extends AbstractReactorEntity
implements INamedContainerProvider {
    public static String COMMAND_SET_NAME = "setname";
    public static String COMMAND_SET_INSERTION = "setinsertion";
    private String _name = "";
    private byte _insertionRatio = 0;

    public ReactorControlRodEntity() {
        super((TileEntityType)Content.TileEntityTypes.REACTOR_CONTROLROD.get());
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(COMMAND_SET_NAME, ReactorControlRodEntity::setNameFromGUI).addServerHandler(COMMAND_SET_INSERTION, ReactorControlRodEntity::setInsertionFromGUI).build((AbstractModBlockEntity)this));
    }

    public void linkToFuelRods(int fuelRodsCount) {
        CodeHelper.optionalIfPresent((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (world, direction) -> this.linkToFuelRods((World)world, direction.func_176734_d(), fuelRodsCount));
    }

    private void linkToFuelRods(World world, Direction direction, int fuelRodsCount) {
        BlockPos lookupPosition = this.getWorldPosition();
        for (int i = 0; i < fuelRodsCount; ++i) {
            int rodIndex = fuelRodsCount - i - 1;
            lookupPosition = lookupPosition.func_177972_a(direction);
            CodeHelper.optionalIfPresentOrThrow(WorldHelper.getTile((World)world, (BlockPos)lookupPosition).filter(te -> te instanceof ReactorFuelRodEntity).map(te -> (ReactorFuelRodEntity)te), rod -> rod.linkToControlRod(this, rodIndex));
        }
    }

    public FuelRodsLayout getFuelRodsLayout() {
        return (FuelRodsLayout)this.evalOnController(IReactorReader::getFuelRodsLayout, FuelRodsLayout.EMPTY);
    }

    public String getName() {
        return this._name;
    }

    public byte getInsertionRatio() {
        return this._insertionRatio;
    }

    public float getInsertionPercentage() {
        return Math.min(1.0f, Math.max(0.0f, (float)this.getInsertionRatio() / 100.0f));
    }

    public static void setName(ReactorControlRodEntity controlRod, String newName) {
        if (controlRod.setName(newName)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void setInsertionRatio(ReactorControlRodEntity controlRod, int newRatio) {
        if (controlRod.setInsertionRatio(newRatio)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void changeInsertionRatio(ReactorControlRodEntity controlRod, int delta) {
        if (controlRod.setInsertionRatio(controlRod.getInsertionRatio() + delta)) {
            controlRod.notifyBlockUpdate();
        }
    }

    public static void setInsertionRatio(Collection<ReactorControlRodEntity> controlRods, int newRatio) {
        Set updated = controlRods.stream().filter(IMultiblockPart::isConnected).filter(rod -> rod.setInsertionRatio(newRatio)).collect(Collectors.toSet());
        if (!updated.isEmpty()) {
            AbstractModBlockEntity.notifyBlockUpdate(updated);
        }
    }

    public static void changeInsertionRatio(Collection<ReactorControlRodEntity> controlRods, int delta) {
        Set updated = controlRods.stream().filter(IMultiblockPart::isConnected).filter(rod -> rod.setInsertionRatio(rod.getInsertionRatio() + delta)).collect(Collectors.toSet());
        if (!updated.isEmpty()) {
            AbstractModBlockEntity.notifyBlockUpdate(updated);
        }
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return ModTileContainer.empty((ContainerType)((ContainerType)Content.ContainerTypes.REACTOR_CONTROLROD.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayerEntity)((ServerPlayerEntity)player));
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.func_74764_b("rodInsertion")) {
            this.setInsertionRatio(data.func_74771_c("rodInsertion"));
        }
        if (data.func_74764_b("rodName")) {
            this.setName(data.func_74779_i("rodName"));
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.func_74774_a("rodInsertion", this.getInsertionRatio());
        data.func_74778_a("rodName", this.getName());
        return data;
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFace()) {
            if (position.getDirection().map(direction -> this.checkForFuelRod(direction.func_176734_d())).orElse(false).booleanValue()) {
                return true;
            }
            validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reactor.invalid_control_rods_position", new Object[0]);
            return false;
        }
        return super.isGoodForPosition(position, validatorCallback);
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    private void setInsertionFromGUI(CompoundNBT data) {
        if (data.func_74764_b("v")) {
            if (data.func_74767_n("all")) {
                this.getMultiblockController().ifPresent(c -> c.setControlRodsInsertionRatio(data.func_74762_e("v")));
            } else {
                this.setInsertionRatio(data.func_74762_e("v"));
            }
        }
    }

    private void setNameFromGUI(CompoundNBT data) {
        if (data.func_74764_b("name")) {
            this.setName(data.func_74779_i("name"));
        }
    }

    private boolean setInsertionRatio(int newRatio) {
        if (this.getInsertionRatio() == newRatio || newRatio < 0 || newRatio > 100) {
            return false;
        }
        this._insertionRatio = (byte)newRatio;
        this.func_70296_d();
        this.notifyBlockUpdate();
        return true;
    }

    private boolean setName(String newName) {
        if (Strings.isNullOrEmpty((String)newName) || this.getName().equals(newName)) {
            return false;
        }
        this._name = newName;
        this.func_70296_d();
        this.notifyBlockUpdate();
        return true;
    }

    private boolean checkForFuelRod(Direction rodDirection) {
        return (Boolean)this.mapPartWorld(world -> WorldHelper.getLoadedTile((IWorldReader)world, (BlockPos)this.getWorldPosition().func_177972_a(rodDirection)) instanceof ReactorFuelRodEntity, false);
    }
}

