/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.AbstractSensorSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorBehavior;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.sensor.ReactorSensorType;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import net.minecraft.nbt.CompoundNBT;

public class ReactorSensorSetting
extends AbstractSensorSetting<IReactorReader, IReactorWriter, ReactorSensorType> {
    public static final ReactorSensorSetting DISABLED = new ReactorSensorSetting();

    public ReactorSensorSetting(ReactorSensorType sensor, SensorBehavior behavior, int v1, int v2) {
        super(sensor, behavior, v1, v2);
    }

    public static ReactorSensorSetting syncDataFrom(CompoundNBT data) {
        try {
            return new ReactorSensorSetting(data);
        }
        catch (IllegalArgumentException ex) {
            Log.LOGGER.error("Invalid NBT data while reading a ReactorSensorSetting");
            return DISABLED;
        }
    }

    @Override
    public CompoundNBT syncDataTo(CompoundNBT data) {
        return super.syncDataTo(NBTHelper.nbtSetEnum((CompoundNBT)data, (String)"sensor", (Enum)((Enum)((Object)this.Sensor))));
    }

    @Override
    public void inputAction(IReactorWriter reactor, Boolean isExternallyPowered, int externalPowerLevel) {
        switch ((ReactorSensorType)this.Sensor) {
            case inputActive: {
                this.acceptInputActive(reactor, isExternallyPowered);
                break;
            }
            case inputSetControlRod: {
                this.acceptInputSetControlRod(reactor, isExternallyPowered, externalPowerLevel);
                break;
            }
            case inputEjectWaste: {
                this.acceptInputEjectWaste(reactor, isExternallyPowered);
            }
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ReactorSensorSetting) {
            ReactorSensorSetting s = (ReactorSensorSetting)other;
            return this == s || this.Sensor == s.Sensor && this.Behavior == s.Behavior && this.Value1 == s.Value1 && this.Value2 == s.Value2;
        }
        return false;
    }

    private ReactorSensorSetting() {
        this(ReactorSensorType.Disabled, SensorBehavior.Disabled, 0, 0);
    }

    protected ReactorSensorSetting(CompoundNBT data) throws IllegalArgumentException {
        super(data, ReactorSensorSetting::readSensorTypeFrom);
    }

    private static ReactorSensorType readSensorTypeFrom(CompoundNBT data) {
        if (!data.func_74764_b("sensor")) {
            throw new IllegalArgumentException("Invalid NBT data");
        }
        return (ReactorSensorType)NBTHelper.nbtGetEnum((CompoundNBT)data, (String)"sensor", ReactorSensorType::valueOf, (Enum)ReactorSensorType.Disabled);
    }

    private void acceptInputActive(IReactorWriter reactor, Boolean isExternallyPowered) {
        switch (this.Behavior) {
            case SetFromSignal: {
                reactor.setMachineActive(isExternallyPowered);
                break;
            }
            case ToggleOnPulse: {
                if (!isExternallyPowered.booleanValue()) break;
                reactor.toggleMachineActive();
            }
        }
    }

    private void acceptInputSetControlRod(IReactorWriter reactor, Boolean isExternallyPowered, int externalPowerLevel) {
        switch (this.Behavior) {
            case SetFromSignal: {
                reactor.setControlRodsInsertionRatio(isExternallyPowered != false ? this.Value1 : this.Value2);
                break;
            }
            case SetFromSignalLevel: {
                reactor.setControlRodsInsertionRatio(isExternallyPowered != false ? (int)((double)externalPowerLevel / 15.0 * 100.0) : 0);
                break;
            }
            case SetOnPulse: {
                reactor.setControlRodsInsertionRatio(this.Value1);
                break;
            }
            case InsertOnPulse: {
                reactor.changeControlRodsInsertionRatio(this.Value1);
                break;
            }
            case RetractOnPulse: {
                reactor.changeControlRodsInsertionRatio(-this.Value1);
            }
        }
    }

    private void acceptInputEjectWaste(IReactorWriter reactor, Boolean isExternallyPowered) {
        if (SensorBehavior.EjectOnPulse == this.Behavior && isExternallyPowered.booleanValue()) {
            reactor.ejectWaste(false);
        }
    }
}

