/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.redui;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.core.vec.Point;
import mrtjp.core.vec.Rect;
import mrtjp.core.vec.Size;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUIRootNode;

public abstract class AbstractGuiNode
implements RedUINode {
    private RedUIRootNode root;
    private RedUINode parent;
    private Point pos = Point.zeroPoint();
    private Size size = Size.zeroSize();
    private Rect frame = new Rect(this.pos, this.size);
    private double zPos = 0.0;
    private boolean isHidden = false;
    private final List<RedUINode> children = new LinkedList<RedUINode>();

    public void setPosition(int x, int y) {
        this.pos = new Point(x, y);
        this.frame = new Rect(this.pos, this.size);
    }

    public void setSize(int width, int height) {
        this.size = new Size(width, height);
        this.frame = new Rect(this.pos, this.size);
    }

    public void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    @Override
    public RedUIRootNode getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(@Nullable RedUIRootNode root) {
        this.root = root;
    }

    @Override
    public RedUINode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable RedUINode parent) {
        this.parent = parent;
    }

    @Override
    public List<RedUINode> getOurChildren() {
        return this.children;
    }

    @Override
    public Rect getFrame() {
        return this.frame;
    }

    @Override
    public Point getPosition() {
        return this.pos;
    }

    @Override
    public double getZPosition() {
        return this.zPos;
    }

    @Override
    public double getRelativeZPosition() {
        return this.getParent().getZPosition() - this.zPos;
    }

    @Override
    public void setZPosition(double zPosition) {
        this.zPos = zPosition;
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }
}

